/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.security.standalone.persistence;

import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Type;
import org.openl.rules.security.standalone.persistence.AccessControlEntry;
import org.openl.rules.security.standalone.persistence.PersistentObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="UserGroup")
public class Group
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private String privileges;
    private Set<Group> includedGroups;
    private Set<AccessControlEntry> accessControlEntries;

    @OneToMany(targetEntity=AccessControlEntry.class, mappedBy="group")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<AccessControlEntry> getAccessControlEntries() {
        return this.accessControlEntries;
    }

    @Column(length=100, name="Description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @Id
    @GeneratedValue(generator="nativeId")
    @GenericGenerator(name="nativeId", strategy="native")
    @Column(name="GroupID")
    @Type(type="java.lang.Long")
    public Long getId() {
        return super.getId();
    }

    @ManyToMany(targetEntity=Group.class, fetch=FetchType.LAZY)
    @JoinTable(name="Group2Group", joinColumns={@JoinColumn(name="GroupID")}, inverseJoinColumns={@JoinColumn(name="IncludedGroupID")})
    @Cascade(value={CascadeType.MERGE, CascadeType.SAVE_UPDATE})
    public Set<Group> getIncludedGroups() {
        return this.includedGroups;
    }

    @Column(length=40, name="GroupName", unique=true, nullable=false)
    public String getName() {
        return this.name;
    }

    @Column(name="Privileges", length=200)
    public String getPrivileges() {
        return this.privileges;
    }

    public void setAccessControlEntries(Set<AccessControlEntry> accessControlEntries) {
        this.accessControlEntries = accessControlEntries;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIncludedGroups(Set<Group> includedGroups) {
        this.includedGroups = includedGroups;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrivileges(String privileges) {
        this.privileges = privileges;
    }
}

