/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.security.standalone.persistence;

import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Type;
import org.openl.rules.security.standalone.persistence.AccessControlEntry;
import org.openl.rules.security.standalone.persistence.Group;
import org.openl.rules.security.standalone.persistence.PersistentObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class User
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    private String loginName;
    private String passwordHash;
    private String privileges;
    private Set<Group> groups;
    private String firstName;
    private String surname;
    private Set<AccessControlEntry> accessControlEntries;

    @OneToMany(targetEntity=AccessControlEntry.class, mappedBy="user")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<AccessControlEntry> getAccessControlEntries() {
        return this.accessControlEntries;
    }

    @Column(name="FirstName", length=50)
    public String getFirstName() {
        return this.firstName;
    }

    @ManyToMany(targetEntity=Group.class, fetch=FetchType.LAZY)
    @JoinTable(name="User2Group", joinColumns={@JoinColumn(name="UserID")}, inverseJoinColumns={@JoinColumn(name="GroupID")})
    @Cascade(value={CascadeType.MERGE, CascadeType.SAVE_UPDATE})
    public Set<Group> getGroups() {
        return this.groups;
    }

    @Override
    @Id
    @GeneratedValue(generator="nativeId")
    @GenericGenerator(name="nativeId", strategy="native")
    @Column(name="UserID")
    @Type(type="java.lang.Long")
    public Long getId() {
        return super.getId();
    }

    @Column(name="LoginName", length=50, nullable=false, unique=true)
    public String getLoginName() {
        return this.loginName;
    }

    @Column(name="Password", length=32, nullable=false)
    public String getPasswordHash() {
        return this.passwordHash;
    }

    @Column(name="Privileges", length=200)
    public String getPrivileges() {
        return this.privileges;
    }

    @Column(name="Surname", length=50)
    public String getSurname() {
        return this.surname;
    }

    public void setAccessControlEntries(Set<AccessControlEntry> accessControlEntries) {
        this.accessControlEntries = accessControlEntries;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setGroups(Set<Group> groups) {
        this.groups = groups;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public void setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
    }

    public void setPrivileges(String privileges) {
        this.privileges = privileges;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }
}

