/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.security.standalone.service;

import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.openl.rules.security.standalone.authentication.UserInfo;
import org.openl.rules.security.standalone.dao.UserDao;
import org.openl.rules.security.standalone.model.User;
import org.openl.rules.security.standalone.service.UserInfoUserDetailsService;
import org.springframework.dao.DataAccessException;

public class UserInfoUserDetailsServiceImpl
implements UserInfoUserDetailsService {
    private UserDao userDao;

    private static User modelUserFromUser(org.openl.rules.security.standalone.persistence.User user) {
        User ret = new User();
        ret.setFirstName(user.getFirstName());
        ret.setLastName(user.getSurname());
        ret.setLoginName(user.getLoginName());
        ret.setPassword(user.getPasswordHash());
        return ret;
    }

    protected GrantedAuthority[] createGrantedAuthorities(org.openl.rules.security.standalone.persistence.User user) {
        LinkedHashSet<GrantedAuthorityImpl> grantedSet = new LinkedHashSet<GrantedAuthorityImpl>();
        String privileges = user.getPrivileges();
        if (privileges != null) {
            StringTokenizer st = new StringTokenizer(privileges, ",");
            while (st.hasMoreElements()) {
                String privilege = st.nextToken();
                grantedSet.add(new GrantedAuthorityImpl(privilege));
            }
        }
        return grantedSet.toArray(new GrantedAuthority[grantedSet.size()]);
    }

    public UserInfo loadUserByUsername(String name) throws UsernameNotFoundException, DataAccessException {
        org.openl.rules.security.standalone.persistence.User user = this.userDao.getUserByName(name);
        if (user == null) {
            throw new UsernameNotFoundException("Unknown user: '" + name + "'");
        }
        GrantedAuthority[] grantedAuthorities = this.createGrantedAuthorities(user);
        return new UserInfo(UserInfoUserDetailsServiceImpl.modelUserFromUser(user), grantedAuthorities);
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }
}

