/*
 * Decompiled with CFR 0.152.
 */
package org.openl;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.openl.ICompileContext;
import org.openl.IOpenBinder;
import org.openl.IOpenParser;
import org.openl.IOpenVM;
import org.openl.cache.CacheUtils;
import org.openl.conf.IOpenLBuilder;
import org.openl.conf.IUserContext;
import org.openl.conf.OpenConfigurationException;
import org.openl.conf.OpenLConfigurator;
import org.openl.conf.UserContext;

public class OpenL {
    private static final String DEFAULT_USER_HOME = ".";
    private static OpenLConfigurator config = new OpenLConfigurator();
    private static Map<Object, OpenL> openlCache = new HashMap<Object, OpenL>();
    private IOpenParser parser;
    private IOpenBinder binder;
    private IOpenVM vm;
    private ICompileContext compileContext;
    private String name;

    public static OpenL getInstance(String name) throws OpenConfigurationException {
        return OpenL.getInstance(name, config.getClassLoader());
    }

    public static synchronized OpenL getInstance(String name, ClassLoader classLoader) throws OpenConfigurationException {
        String currentWorkDirectory = new File(DEFAULT_USER_HOME).getAbsolutePath();
        return OpenL.getInstance(name, new UserContext(classLoader, currentWorkDirectory));
    }

    public static synchronized OpenL getInstance(String name, IUserContext userContext) throws OpenConfigurationException {
        Object key = CacheUtils.makeKey(name, userContext);
        OpenL openl = openlCache.get(key);
        if (openl == null) {
            IOpenLBuilder builder = config.getBuilder(name, userContext);
            openl = OpenL.createInstance(name, userContext, builder);
            openlCache.put(key, openl);
        }
        return openl;
    }

    public static OpenL getInstance(String name, IUserContext userContext, IOpenLBuilder builder) {
        Object key = CacheUtils.makeKey(name, userContext);
        OpenL openl = openlCache.get(key);
        if (openl == null) {
            openl = OpenL.createInstance(name, userContext, builder);
            openlCache.put(key, openl);
        }
        return openl;
    }

    private static OpenL createInstance(String name, IUserContext userContext, IOpenLBuilder builder) {
        OpenL openl = builder.build(name);
        openl.setName(name);
        return openl;
    }

    public static synchronized OpenL remove(String name) throws OpenConfigurationException {
        return OpenL.remove(name, config.getClassLoader());
    }

    public static synchronized OpenL remove(String name, ClassLoader classLoader) throws OpenConfigurationException {
        return OpenL.remove(name, new UserContext(classLoader, DEFAULT_USER_HOME));
    }

    public static synchronized OpenL remove(String name, IUserContext userContext) {
        Object key = CacheUtils.makeKey(name, userContext);
        OpenL openl = openlCache.get(key);
        if (openl == null) {
            return null;
        }
        openlCache.remove(key);
        return openl;
    }

    public static void reset() {
        openlCache = new HashMap<Object, OpenL>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IOpenParser getParser() {
        return this.parser;
    }

    public void setParser(IOpenParser parser) {
        this.parser = parser;
    }

    public IOpenVM getVm() {
        return this.vm;
    }

    public void setVm(IOpenVM openVM) {
        this.vm = openVM;
    }

    public IOpenBinder getBinder() {
        return this.binder;
    }

    public void setBinder(IOpenBinder binder) {
        this.binder = binder;
    }

    public ICompileContext getCompileContext() {
        return this.compileContext;
    }

    public void setCompileContext(ICompileContext compileContext) {
        this.compileContext = compileContext;
    }
}

