/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding;

import java.lang.reflect.Method;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.reflect.MethodUtils;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenMethodHeader;
import org.openl.util.print.Formatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodUtil {
    public static StringBuffer printMethod(IOpenMethod method, StringBuffer buf) {
        return MethodUtil.printMethod(method.getName(), method.getSignature(), buf);
    }

    public static String printMethod(IOpenMethodHeader methodHeader, int mode, boolean printType) {
        StringBuffer buf = new StringBuffer(100);
        if (printType) {
            buf.append(methodHeader.getType().getDisplayName(mode)).append(' ');
        }
        MethodUtil.startPrintingMethodName(methodHeader.getName(), buf);
        IMethodSignature signature = methodHeader.getSignature();
        for (int i = 0; i < signature.getNumberOfParameters(); ++i) {
            MethodUtil.printParameterInfo(signature.getParameterType(i).getDisplayName(mode), signature.getParameterName(i), i == 0, buf);
        }
        MethodUtil.endPrintingMethodName(buf);
        return buf.toString();
    }

    public static String printMethod(String name, Class<?>[] params) {
        return MethodUtil.printMethod(name, params, new StringBuffer()).toString();
    }

    public static StringBuffer printMethod(String name, Class<?>[] params, StringBuffer buf) {
        MethodUtil.startPrintingMethodName(name, buf);
        for (int i = 0; i < params.length; ++i) {
            MethodUtil.printParameterInfo(params[i].getName(), null, i == 0, buf);
        }
        MethodUtil.endPrintingMethodName(buf);
        return buf;
    }

    public static StringBuffer printMethod(String name, IMethodSignature signature, StringBuffer buf) {
        MethodUtil.startPrintingMethodName(name, buf);
        for (int i = 0; i < signature.getNumberOfParameters(); ++i) {
            MethodUtil.printParameterInfo(signature.getParameterType(i).getName(), signature.getParameterName(i), i == 0, buf);
        }
        MethodUtil.endPrintingMethodName(buf);
        return buf;
    }

    public static String printMethod(String name, IOpenClass[] params) {
        return MethodUtil.printMethod(name, params, new StringBuffer()).toString();
    }

    public static StringBuffer printMethod(String name, IOpenClass[] params, StringBuffer buf) {
        MethodUtil.startPrintingMethodName(name, buf);
        for (int i = 0; i < params.length; ++i) {
            MethodUtil.printParameterInfo(params[i].getName(), null, i == 0, buf);
        }
        MethodUtil.endPrintingMethodName(buf);
        return buf;
    }

    public static StringBuffer printMethodWithParameterValues(IOpenMethod method, Object[] params, int mode, StringBuffer buf) {
        MethodUtil.startPrintingMethodName(method.getName(), buf);
        IMethodSignature signature = method.getSignature();
        for (int i = 0; i < params.length; ++i) {
            MethodUtil.printParameterInfo(null, signature.getParameterName(i), params[i], i == 0, mode, buf);
        }
        MethodUtil.endPrintingMethodName(buf);
        return buf;
    }

    public static String printMethodWithParameterValues(IOpenMethod method, Object[] params, int mode) {
        return MethodUtil.printMethodWithParameterValues(method, params, mode, new StringBuffer()).toString();
    }

    private static void startPrintingMethodName(String name, StringBuffer buf) {
        buf.append(name).append('(');
    }

    private static void endPrintingMethodName(StringBuffer buf) {
        buf.append(')');
    }

    private static void printParameterInfo(String type, String name, boolean isFirst, StringBuffer buf) {
        MethodUtil.printParameterInfo(type, name, null, isFirst, 0, buf);
    }

    private static void printParameterInfo(String type, String name, Object value, boolean isFirst, int displayMode, StringBuffer buf) {
        if (!isFirst) {
            buf.append(", ");
        }
        if (type != null) {
            buf.append(type);
        }
        if (type != null && name != null) {
            buf.append(' ');
        }
        if (name != null) {
            buf.append(name);
        }
        if (value != null) {
            buf.append(" = ");
            Formatter.format((Object)value, (int)displayMode, (StringBuffer)buf);
        }
    }

    public static Method getMatchingAccessibleMethod(Class<?> methodOwner, String methodName, Class<?>[] argTypes, boolean autoboxing) {
        Method[] methods;
        Method resultMethod = null;
        for (Method method : methods = methodOwner.getMethods()) {
            Class[] signatureParams = method.getParameterTypes();
            if (!methodName.equals(method.getName()) || signatureParams.length != argTypes.length || !ClassUtils.isAssignable((Class[])argTypes, (Class[])signatureParams, (boolean)autoboxing) || (method = MethodUtils.getAccessibleMethod((Method)method)) == null) continue;
            resultMethod = resultMethod != null ? MethodUtil.getCloserMethod(resultMethod, method, argTypes, autoboxing) : method;
        }
        return resultMethod;
    }

    private static Method getCloserMethod(Method firstMethod, Method secondMethod, Class<?>[] argTypes, boolean autoboxing) {
        int firstTransfCount = MethodUtil.getTransformationsCount(firstMethod.getParameterTypes(), argTypes, autoboxing);
        if (firstTransfCount < 0) {
            return secondMethod;
        }
        int secondTransfCount = MethodUtil.getTransformationsCount(secondMethod.getParameterTypes(), argTypes, autoboxing);
        if (secondTransfCount < 0 || secondTransfCount >= firstTransfCount) {
            return firstMethod;
        }
        return secondMethod;
    }

    private static int getTransformationsCount(Class<?>[] signatureToCheck, Class<?>[] argTypes, boolean autoboxing) {
        int transformationsCount = 0;
        for (int i = 0; i < argTypes.length; ++i) {
            if (signatureToCheck[i].equals(argTypes[i])) continue;
            if (!ClassUtils.isAssignable(argTypes[i], signatureToCheck[i], (boolean)autoboxing)) {
                return -1;
            }
            ++transformationsCount;
        }
        return transformationsCount;
    }
}

