/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.exception;

import java.util.List;
import org.openl.binding.MethodUtil;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmbiguousMethodException
extends RuntimeException {
    private static final long serialVersionUID = -4733490029481524664L;
    List<IOpenMethod> matchingMethods;
    String methodName;
    IOpenClass[] pars;

    public AmbiguousMethodException(String methodName, IOpenClass[] pars, List<IOpenMethod> matchingMethods) {
        this.methodName = methodName;
        this.pars = pars;
        this.matchingMethods = matchingMethods;
    }

    @Override
    public String getMessage() {
        StringBuffer buf = new StringBuffer();
        buf.append("Method ");
        MethodUtil.printMethod(this.methodName, this.pars, buf);
        buf.append(" is ambigous:\n").append("Matching methods:\n");
        for (IOpenMethod method : this.matchingMethods) {
            MethodUtil.printMethod(method, buf).append('\n');
        }
        return buf.toString();
    }
}

