/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.INodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.CastNode;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.TypeCastException;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;
import org.openl.types.NullOpenClass;

public abstract class ANodeBinder
implements INodeBinder {
    public static IBoundNode bindChildNode(ISyntaxNode node, IBindingContext bindingContext) {
        INodeBinder binder = ANodeBinder.findBinder(node, bindingContext);
        if (binder == null) {
            return new ErrorBoundNode(node);
        }
        try {
            return binder.bind(node, bindingContext);
        }
        catch (Throwable t) {
            BindHelper.processError(t.getMessage(), node, bindingContext, false);
            return new ErrorBoundNode(node);
        }
    }

    public static IBoundNode bindTargetNode(ISyntaxNode node, IBindingContext bindingContext, IBoundNode targetNode) {
        INodeBinder binder = ANodeBinder.findBinder(node, bindingContext);
        if (binder == null) {
            return new ErrorBoundNode(node);
        }
        try {
            return binder.bindTarget(node, bindingContext, targetNode);
        }
        catch (Throwable t) {
            BindHelper.processError(node, t, bindingContext);
            return new ErrorBoundNode(node);
        }
    }

    public static IBoundNode bindTypeNode(ISyntaxNode node, IBindingContext bindingContext, IOpenClass type) {
        INodeBinder binder = ANodeBinder.findBinder(node, bindingContext);
        if (binder == null) {
            return new ErrorBoundNode(node);
        }
        try {
            return binder.bindType(node, bindingContext, type);
        }
        catch (Throwable t) {
            BindHelper.processError(node, t, bindingContext);
            return new ErrorBoundNode(node);
        }
    }

    public static IBoundNode[] bindChildren(ISyntaxNode parentNode, IBindingContext bindingContext) throws SyntaxNodeException {
        return ANodeBinder.bindChildren(parentNode, bindingContext, 0, parentNode.getNumberOfChildren());
    }

    public static IBoundNode[] bindChildren(ISyntaxNode parentNode, IBindingContext bindingContext, int from, int to) throws SyntaxNodeException {
        int n = to - from;
        if (n == 0) {
            return new IBoundNode[0];
        }
        IBoundNode[] children = new IBoundNode[n];
        int boundNodesCount = 0;
        for (int i = 0; i < n; ++i) {
            ISyntaxNode childNode = parentNode.getChild(from + i);
            if (childNode == null) {
                ++boundNodesCount;
                continue;
            }
            children[i] = ANodeBinder.bindChildNode(childNode, bindingContext);
            ++boundNodesCount;
        }
        if (boundNodesCount != n) {
            String message = "Can not bind node";
            BindHelper.processError(message, parentNode, bindingContext);
            ErrorBoundNode errorBoundNode = new ErrorBoundNode(parentNode);
            return new IBoundNode[]{errorBoundNode};
        }
        return children;
    }

    public static IBoundNode[] bindTypeChildren(ISyntaxNode parentNode, IBindingContext bindingContext, IOpenClass type) {
        return ANodeBinder.bindTypeChildren(parentNode, bindingContext, type, 0, parentNode.getNumberOfChildren());
    }

    public static IBoundNode[] bindTypeChildren(ISyntaxNode parentNode, IBindingContext bindingContext, IOpenClass type, int from, int to) {
        int n = to - from;
        if (n == 0) {
            return new IBoundNode[0];
        }
        IBoundNode[] children = new IBoundNode[n];
        for (int i = 0; i < n; ++i) {
            ISyntaxNode childNode = parentNode.getChild(from + i);
            if (childNode == null) continue;
            children[i] = ANodeBinder.bindChildNode(childNode, bindingContext);
        }
        return children;
    }

    public static IOpenClass[] getTypes(IBoundNode[] nodes) {
        IOpenClass[] types = new IOpenClass[nodes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = nodes[i].getType();
        }
        return types;
    }

    private static INodeBinder findBinder(ISyntaxNode node, IBindingContext bindingContext) {
        INodeBinder binder = bindingContext.findBinder(node);
        if (binder == null) {
            String message = String.format("Can not find binder for node type '%s'", node.getType());
            BindHelper.processError(message, node, bindingContext);
        }
        return binder;
    }

    private static IBoundNode convertType(IBoundNode node, IBindingContext bindingContext, IOpenClass type) throws Exception {
        IOpenCast cast = ANodeBinder.getCast(node, type, bindingContext);
        if (cast == null) {
            return node;
        }
        return new CastNode(null, node, cast, type);
    }

    public static IOpenCast getCast(IBoundNode node, IOpenClass to, IBindingContext bindingContext) throws TypeCastException {
        IOpenClass from = node.getType();
        if (from == null) {
            throw new TypeCastException(node.getSyntaxNode(), NullOpenClass.the, to);
        }
        if (from.equals(to)) {
            return null;
        }
        IOpenCast cast = bindingContext.getCast(from, to);
        if (cast == null || !cast.isImplicit()) {
            throw new TypeCastException(node.getSyntaxNode(), from, to);
        }
        return cast;
    }

    public static String getIdentifier(ISyntaxNode node) {
        return ((IdentifierNode)node).getIdentifier();
    }

    public IBoundNode bindTarget(ISyntaxNode node, IBindingContext bindingContext, IBoundNode targetNode) throws Exception {
        BindHelper.processError("This node does not support target binding", node, bindingContext);
        return new ErrorBoundNode(node);
    }

    public IBoundNode bindType(ISyntaxNode node, IBindingContext bindingContext, IOpenClass type) throws Exception {
        IBoundNode boundNode = ANodeBinder.bindChildNode(node, bindingContext);
        return ANodeBinder.convertType(boundNode, bindingContext, type);
    }
}

