/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.BindingDependencies;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ATargetBoundNode;
import org.openl.exception.OpenLRuntimeException;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.vm.IRuntimeEnv;

public class FieldBoundNode
extends ATargetBoundNode {
    IOpenField boundField;

    public FieldBoundNode(ISyntaxNode syntaxNode, IOpenField field) {
        super(syntaxNode, new IBoundNode[0]);
        this.boundField = field;
    }

    public FieldBoundNode(ISyntaxNode syntaxNode, IOpenField field, IBoundNode target) {
        super(syntaxNode, new IBoundNode[0], target);
        this.boundField = field;
    }

    public void assign(Object value, IRuntimeEnv env) throws OpenLRuntimeException {
        Object target = this.targetNode == null ? env.getThis() : this.targetNode.evaluate(env);
        this.boundField.set(target, value, env);
    }

    public Object evaluateRuntime(IRuntimeEnv env) throws OpenLRuntimeException {
        Object target = this.targetNode == null ? env.getThis() : this.targetNode.evaluate(env);
        return this.boundField.get(target, env);
    }

    public IOpenClass getType() {
        return this.boundField.getType();
    }

    public boolean isLvalue() {
        return this.boundField.isWritable();
    }

    public void updateAssignFieldDependency(BindingDependencies dependencies) {
        dependencies.addAssignField(this.boundField, this);
    }

    public void updateDependency(BindingDependencies dependencies) {
        dependencies.addFieldDependency(this.boundField, this);
    }

    public boolean isLiteralExpressionParent() {
        return this.boundField.isConst();
    }
}

