/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.BindingDependencies;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ATargetBoundNode;
import org.openl.binding.impl.ControlSignalReturn;
import org.openl.exception.OpenLRuntimeException;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;
import org.openl.vm.IRuntimeEnv;

public class MethodBoundNode
extends ATargetBoundNode {
    protected IMethodCaller boundMethod;

    public MethodBoundNode(ISyntaxNode syntaxNode, IBoundNode[] child, IMethodCaller method) {
        super(syntaxNode, child);
        this.boundMethod = method;
    }

    public MethodBoundNode(ISyntaxNode syntaxNode, IBoundNode[] child, IMethodCaller method, IBoundNode targetNode) {
        super(syntaxNode, child, targetNode);
        this.boundMethod = method;
    }

    public Object evaluateRuntime(IRuntimeEnv env) throws OpenLRuntimeException {
        try {
            Object target = this.targetNode == null ? env.getThis() : this.targetNode.evaluate(env);
            Object[] pars = this.evaluateChildren(env);
            return this.boundMethod.invoke(target, pars, env);
        }
        catch (ControlSignalReturn signal) {
            return signal.getReturnValue();
        }
        catch (OpenLRuntimeException opex) {
            opex.pushMethodNode(this);
            throw opex;
        }
    }

    public IOpenClass getType() {
        return this.boundMethod.getMethod().getType();
    }

    public void updateDependency(BindingDependencies dependencies) {
        dependencies.addMethodDependency(this.boundMethod.getMethod(), this);
    }

    public boolean isLiteralExpressionParent() {
        return this.boundMethod.getMethod().isStatic() && this.hasLiteralReturnType(this.boundMethod.getMethod().getType());
    }

    private boolean hasLiteralReturnType(IOpenClass type) {
        return type != JavaOpenClass.VOID;
    }
}

