/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.openl.binding.ICastFactory;
import org.openl.binding.IMethodFactory;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.CastingMethodCaller;
import org.openl.util.AOpenIterator;
import org.openl.util.ASelector;
import org.openl.util.ISelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodSearch {
    static final int NO_MATCH = Integer.MAX_VALUE;

    protected static int calcMatch(IOpenClass[] methodParam, IOpenClass[] callParam, ICastFactory casts, IOpenCast[] castHolder) {
        int maxdiff = 0;
        int ndiff = 0;
        for (int i = 0; i < callParam.length; ++i) {
            if (callParam[i] == methodParam[i]) continue;
            IOpenCast cast = casts.getCast(callParam[i], methodParam[i]);
            if (cast == null || !cast.isImplicit()) {
                return Integer.MAX_VALUE;
            }
            castHolder[i] = cast;
            maxdiff = Math.max(maxdiff, cast.getDistance(callParam[i], methodParam[i]));
            ++ndiff;
        }
        return maxdiff * 100 + ndiff;
    }

    protected static IMethodCaller getCastingMethodCaller(String name, IOpenClass[] params, ICastFactory casts, IMethodFactory factory) throws AmbiguousMethodException {
        ArrayList<IOpenMethod> matchingMethods = new ArrayList<IOpenMethod>();
        int bestMatch = Integer.MAX_VALUE;
        IOpenCast[] bestCastHolder = null;
        Iterator<IOpenMethod> iter = MethodSearch.methods(name, params.length, factory);
        while (iter.hasNext()) {
            IOpenMethod method = iter.next();
            IOpenCast[] castHolder = new IOpenCast[params.length];
            int match = MethodSearch.calcMatch(method.getSignature().getParameterTypes(), params, casts, castHolder);
            if (match == Integer.MAX_VALUE) continue;
            if (match < bestMatch) {
                bestMatch = match;
                matchingMethods.clear();
                matchingMethods.add(method);
                bestCastHolder = castHolder;
                continue;
            }
            if (match != bestMatch) continue;
            matchingMethods.add(method);
        }
        switch (matchingMethods.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return new CastingMethodCaller((IOpenMethod)matchingMethods.get(0), bestCastHolder);
            }
        }
        throw new AmbiguousMethodException(name, params, matchingMethods);
    }

    public static IMethodCaller getMethodCaller(String name, IOpenClass[] params, ICastFactory casts, IMethodFactory factory) throws AmbiguousMethodException {
        IOpenMethod caller = factory.getMatchingMethod(name, params);
        if (caller != null) {
            return caller;
        }
        if (params.length == 0 || casts == null) {
            return null;
        }
        return MethodSearch.getCastingMethodCaller(name, params, casts, factory);
    }

    protected static Iterator<IOpenMethod> methods(String name, int nParams, IMethodFactory factory) {
        Iterator<IOpenMethod> it = factory.methods();
        if (it == null) {
            return AOpenIterator.empty();
        }
        return AOpenIterator.select(it, (ISelector)new NameAndParSelector(name, nParams));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NameAndParSelector
    extends ASelector<IOpenMethod> {
        String name;
        int nParams;

        NameAndParSelector(String name, int nParams) {
            this.name = name;
            this.nParams = nParams;
        }

        protected boolean equalsSelector(ASelector<IOpenMethod> sel) {
            return false;
        }

        protected int redefinedHashCode() {
            return 0;
        }

        public boolean select(IOpenMethod method) {
            return method.getName().equals(this.name) && method.getSignature().getParameterTypes().length == this.nParams;
        }
    }
}

