/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import java.util.Iterator;
import org.openl.binding.IOpenLibrary;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.util.AOpenIterator;
import org.openl.util.ASelector;
import org.openl.util.ISelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticClassLibrary
implements IOpenLibrary {
    private IOpenClass openClass;

    public StaticClassLibrary() {
    }

    public StaticClassLibrary(IOpenClass openClass) {
        this.openClass = openClass;
    }

    @Override
    public IOpenMethod getMatchingMethod(String name, IOpenClass[] params) {
        return this.openClass.getMethod(name, params);
    }

    @Override
    public IOpenField getVar(String name, boolean strictMatch) {
        return this.openClass.getField(name, strictMatch);
    }

    @Override
    public Iterator<IOpenMethod> methods() {
        ASelector<IOpenMethod> sel = new ASelector<IOpenMethod>(){

            public int redefinedHashCode() {
                return "static".hashCode();
            }

            public boolean select(IOpenMethod m) {
                return m.isStatic();
            }
        };
        return AOpenIterator.select(this.openClass.methods(), (ISelector)sel);
    }

    public void setOpenClass(IOpenClass c) {
        this.openClass = c;
    }
}

