/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.ANodeBinder;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.ErrorBoundNode;
import org.openl.binding.impl.TypeBoundNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;

public class TypeBinder
extends ANodeBinder {
    public IBoundNode bind(ISyntaxNode node, IBindingContext bindingContext) throws Exception {
        ISyntaxNode typeNode = node.getChild(0);
        int dimension = 0;
        while (!(typeNode instanceof IdentifierNode)) {
            typeNode = typeNode.getChild(0);
            ++dimension;
        }
        String typeName = ((IdentifierNode)typeNode).getIdentifier();
        IOpenClass varType = bindingContext.findType("org.openl.this", typeName);
        if (varType == null) {
            String message = String.format("Cannot bind node: '%s'", node.getModule().getCode());
            BindHelper.processError(message, node, bindingContext, false);
            return new ErrorBoundNode(node);
        }
        if (dimension > 0) {
            varType = varType.getAggregateInfo().getIndexedAggregateType(varType, dimension);
        }
        return new TypeBoundNode(node, varType);
    }
}

