/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl.cast;

import java.util.HashMap;
import org.apache.commons.lang.ClassUtils;
import org.openl.binding.ICastFactory;
import org.openl.binding.IMethodFactory;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.binding.impl.cast.AliasToTypeCast;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.binding.impl.cast.JavaBoxingCast;
import org.openl.binding.impl.cast.JavaDownCast;
import org.openl.binding.impl.cast.JavaUnboxingCast;
import org.openl.binding.impl.cast.JavaUpCast;
import org.openl.binding.impl.cast.MethodBasedCast;
import org.openl.binding.impl.cast.TypeToAliasCast;
import org.openl.cache.CacheUtils;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.java.JavaOpenClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CastFactory
implements ICastFactory {
    private static final String AUTO_CAST_METHOD_NAME = "autocast";
    private static final String CAST_METHOD_NAME = "cast";
    private static final String DISTANCE_METHOD_NAME = "distance";
    private static final JavaDownCast JAVA_DOWN_CAST = new JavaDownCast();
    private static final JavaUpCast JAVA_UP_CAST = new JavaUpCast();
    private static final JavaBoxingCast JAVA_BOXING_CAST = new JavaBoxingCast();
    private static final JavaUnboxingCast JAVA_UNBOXING_CAST = new JavaUnboxingCast();
    private IMethodFactory methodFactory;
    private HashMap<Object, IOpenCast> castCache = new HashMap();

    public IMethodFactory getMethodFactory() {
        return this.methodFactory;
    }

    public void setMethodFactory(IMethodFactory factory) {
        this.methodFactory = factory;
    }

    @Override
    public synchronized IOpenCast getCast(IOpenClass from, IOpenClass to) {
        Object key = CacheUtils.makeKey(from, to);
        IOpenCast cast = this.castCache.get(key);
        if (cast == null) {
            cast = this.findCast(from, to);
            this.castCache.put(key, cast);
        }
        return cast;
    }

    public IOpenCast findCast(IOpenClass from, IOpenClass to) {
        if (to == NullOpenClass.the) {
            return null;
        }
        if (from == NullOpenClass.the && this.isPrimitive(to)) {
            return null;
        }
        if (from == NullOpenClass.the && !this.isPrimitive(to)) {
            return JAVA_UP_CAST;
        }
        if (from == JavaOpenClass.OBJECT && this.isPrimitive(to)) {
            return null;
        }
        if (from == JavaOpenClass.OBJECT && !this.isPrimitive(to)) {
            return JAVA_DOWN_CAST;
        }
        IOpenCast typeCast = this.findAliasCast(from, to);
        if (typeCast != null) {
            return typeCast;
        }
        typeCast = this.findJavaCast(from, to);
        if (typeCast != null) {
            return typeCast;
        }
        typeCast = this.findMethodBasedCast(from, to, this.methodFactory);
        if (typeCast != null) {
            return typeCast;
        }
        return null;
    }

    private boolean isPrimitive(IOpenClass openClass) {
        return openClass != null && openClass.getInstanceClass() != null && openClass.getInstanceClass().isPrimitive();
    }

    private IOpenCast findJavaCast(IOpenClass from, IOpenClass to) {
        IOpenCast typeCast = this.findAutoBoxingCast(from, to);
        if (typeCast != null) {
            return typeCast;
        }
        typeCast = this.findUnBoxingCast(from, to);
        if (typeCast != null) {
            return typeCast;
        }
        Class<?> fromClass = from.getInstanceClass();
        Class<?> toClass = to.getInstanceClass();
        if (toClass.isAssignableFrom(fromClass)) {
            return JAVA_UP_CAST;
        }
        if (this.isAllowJavaDowncast(fromClass, toClass)) {
            return JAVA_DOWN_CAST;
        }
        return null;
    }

    private IOpenCast findAutoBoxingCast(IOpenClass from, IOpenClass to) {
        Class<?> toClass;
        if (from == null || to == null || !this.isPrimitive(from) || this.isPrimitive(to)) {
            return null;
        }
        Class<?> fromClass = from.getInstanceClass();
        if (fromClass == ClassUtils.wrapperToPrimitive(toClass = to.getInstanceClass())) {
            return JAVA_BOXING_CAST;
        }
        return null;
    }

    private IOpenCast findUnBoxingCast(IOpenClass from, IOpenClass to) {
        if (from == null || to == null || this.isPrimitive(from) || !this.isPrimitive(to)) {
            return null;
        }
        Class<?> fromClass = from.getInstanceClass();
        Class<?> toClass = to.getInstanceClass();
        if (toClass == ClassUtils.wrapperToPrimitive(fromClass)) {
            return JAVA_UNBOXING_CAST;
        }
        return null;
    }

    private IOpenCast findAliasCast(IOpenClass from, IOpenClass to) {
        if (from instanceof DomainOpenClass || to instanceof DomainOpenClass) {
            if (from instanceof DomainOpenClass && !(to instanceof DomainOpenClass) && to.getInstanceClass().isAssignableFrom(from.getInstanceClass())) {
                return new AliasToTypeCast(from, to);
            }
            if (to instanceof DomainOpenClass && !(from instanceof DomainOpenClass) && from.getInstanceClass().isAssignableFrom(to.getInstanceClass())) {
                return new TypeToAliasCast(from, to);
            }
        }
        return null;
    }

    private IOpenCast findMethodBasedCast(IOpenClass from, IOpenClass to, IMethodFactory methodFactory) {
        IOpenCast typeCast = this.findMethodCast(from, to, methodFactory);
        if (typeCast != null) {
            return typeCast;
        }
        typeCast = this.findMethodCast(from, to, from);
        if (typeCast != null) {
            return typeCast;
        }
        typeCast = this.findMethodCast(from, to, to);
        if (typeCast != null) {
            return typeCast;
        }
        return null;
    }

    private IOpenCast findMethodCast(IOpenClass from, IOpenClass to, IMethodFactory methodFactory) {
        boolean auto = true;
        int distance = 5;
        IOpenMethod castCaller = null;
        try {
            Class primitiveClass;
            castCaller = methodFactory.getMatchingMethod(AUTO_CAST_METHOD_NAME, new IOpenClass[]{from, to});
            if (castCaller == null && (primitiveClass = ClassUtils.wrapperToPrimitive(from.getInstanceClass())) != null) {
                distance = 6;
                JavaOpenClass wrapperOpenClass = JavaOpenClass.getOpenClass(primitiveClass);
                castCaller = methodFactory.getMatchingMethod(AUTO_CAST_METHOD_NAME, new IOpenClass[]{wrapperOpenClass, to});
            }
        }
        catch (AmbiguousMethodException ex) {
            // empty catch block
        }
        if (castCaller == null) {
            auto = false;
            distance = 8;
            try {
                castCaller = methodFactory.getMatchingMethod(CAST_METHOD_NAME, new IOpenClass[]{from, to});
            }
            catch (AmbiguousMethodException ex) {
                // empty catch block
            }
        }
        if (castCaller == null) {
            return null;
        }
        IOpenMethod distanceCaller = null;
        try {
            distanceCaller = methodFactory.getMatchingMethod(DISTANCE_METHOD_NAME, new IOpenClass[]{from, to});
        }
        catch (AmbiguousMethodException ex) {
            // empty catch block
        }
        if (distanceCaller != null) {
            distance = (Integer)distanceCaller.invoke(null, new Object[]{from.nullObject(), to.nullObject()}, null);
        }
        return new MethodBasedCast(castCaller, auto, distance, to.nullObject());
    }

    private boolean isAllowJavaDowncast(Class<?> from, Class<?> to) {
        if (from.isAssignableFrom(to)) {
            return true;
        }
        if (!from.isPrimitive() && to.isInterface()) {
            return true;
        }
        return !to.isPrimitive() && from.isInterface();
    }
}

