/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl.module;

import org.openl.binding.IBindingContext;
import org.openl.binding.ILocalVar;
import org.openl.binding.exception.AmbiguousVarException;
import org.openl.binding.exception.DuplicatedVarException;
import org.openl.binding.impl.BindingContextDelegator;
import org.openl.binding.impl.LocalFrameBuilder;
import org.openl.binding.impl.module.RootDictionaryContext;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.NullOpenClass;
import org.openl.util.RuntimeExceptionWrapper;

public class MethodBindingContext
extends BindingContextDelegator {
    static final int STATUS_ADDING_PARAMS = 0;
    static final int STATUS_ADDING_LOCAL_VARS = 1;
    public static final boolean DEFAULT_SEARCH_IN_CONTEXT = true;
    public static final int DEFAULT_CONTEXT_LEVEL = 1;
    LocalFrameBuilder localFrame = new LocalFrameBuilder();
    int paramFrameSize = 0;
    int status = 0;
    IOpenClass returnType;
    IOpenMethodHeader header;
    boolean searchInParameterContext;
    int parameterContextDepthLevel;
    ILocalVar[] paramVars;
    RootDictionaryContext rootContext;

    public MethodBindingContext(IOpenMethodHeader header, IBindingContext delegate) {
        this(header, delegate, true, 1);
    }

    public MethodBindingContext(IOpenMethodHeader header, IBindingContext delegate, boolean searchInParameterContext, int parameterContextDepthLevel) {
        super(delegate);
        this.header = header;
        this.searchInParameterContext = searchInParameterContext;
        this.parameterContextDepthLevel = parameterContextDepthLevel;
        this.pushLocalVarContext();
        IMethodSignature signature = header.getSignature();
        IOpenClass[] params = signature.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            try {
                this.addParameter("org.openl.this", signature.getParameterName(i), params[i]);
                continue;
            }
            catch (DuplicatedVarException e) {
                throw RuntimeExceptionWrapper.wrap((String)e.getMessage(), (Throwable)e);
            }
        }
        this.paramVars = this.localFrame.getTopFrame().toArray(new ILocalVar[0]);
    }

    public ILocalVar addParameter(String namespace, String name, IOpenClass type) throws DuplicatedVarException {
        if (this.status != 0) {
            throw new IllegalStateException();
        }
        ++this.paramFrameSize;
        return this.localFrame.addVar(namespace, name, type);
    }

    public ILocalVar addVar(String namespace, String name, IOpenClass type) throws DuplicatedVarException {
        this.status = 1;
        return this.localFrame.addVar(namespace, name, type);
    }

    public IOpenField findVar(String namespace, String name, boolean strictMatch) throws AmbiguousVarException {
        IOpenField var = this.localFrame.findLocalVar(namespace, name);
        if (var != null) {
            return var;
        }
        var = this.delegate.findVar(namespace, name, strictMatch);
        if (var != null) {
            return var;
        }
        if (this.searchInParameterContext) {
            RootDictionaryContext cxt = this.getRootContext(this.parameterContextDepthLevel);
            return cxt.findField(name);
        }
        return null;
    }

    public int getLocalVarFrameSize() {
        return this.localFrame.getLocalVarFrameSize();
    }

    public int getParamFrameSize() {
        return this.paramFrameSize;
    }

    public IOpenClass getReturnType() {
        return this.returnType == null ? this.header.getType() : this.returnType;
    }

    private RootDictionaryContext getRootContext(int depthLevel) {
        if (this.rootContext == null) {
            this.rootContext = new RootDictionaryContext(this.paramVars, depthLevel);
        }
        return this.rootContext;
    }

    public void popLocalVarContext() {
        this.localFrame.popLocalVarcontext();
    }

    public void pushLocalVarContext() {
        this.localFrame.pushLocalVarContext();
    }

    public void setReturnType(IOpenClass type) {
        if (this.getReturnType() != NullOpenClass.the) {
            throw new RuntimeException("Can not override return type " + this.getReturnType());
        }
        this.returnType = type;
    }
}

