/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl.module;

import java.util.HashMap;
import java.util.Map;
import org.openl.binding.IBindingContext;
import org.openl.binding.ILocalVar;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.binding.exception.AmbiguousVarException;
import org.openl.binding.exception.DuplicatedVarException;
import org.openl.binding.impl.BindingContextDelegator;
import org.openl.binding.impl.MethodSearch;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.types.IMethodCaller;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleBindingContext
extends BindingContextDelegator {
    private ModuleOpenClass module;
    private Map<String, IOpenClass> internalTypes = null;

    public ModuleBindingContext(IBindingContext delegate, ModuleOpenClass module) {
        super(delegate);
        this.module = module;
    }

    @Override
    public synchronized void addType(String namespace, IOpenClass type) throws Exception {
        String key = this.typeKey(namespace, type.getName());
        Map<String, IOpenClass> map = this.initInternalTypes();
        if (map.containsKey(key)) {
            throw new Exception("Type " + key + " has been defined already");
        }
        map.put(key, type);
    }

    @Override
    public synchronized void removeType(String namespace, IOpenClass type) throws Exception {
        String key = this.typeKey(namespace, type.getName());
        Map<String, IOpenClass> map = this.initInternalTypes();
        map.remove(key);
    }

    @Override
    public ILocalVar addVar(String namespace, String name, IOpenClass type) throws DuplicatedVarException {
        return null;
    }

    @Override
    public IMethodCaller findMethodCaller(String namespace, String methodName, IOpenClass[] parTypes) throws AmbiguousMethodException {
        IMethodCaller imc = null;
        if ("org.openl.this".equals(namespace)) {
            imc = MethodSearch.getMethodCaller(methodName, parTypes, this, this.module);
        }
        return imc != null ? imc : super.findMethodCaller(namespace, methodName, parTypes);
    }

    @Override
    public IOpenClass findType(String namespace, String typeName) {
        String key;
        IOpenClass ioc;
        if (this.internalTypes != null && (ioc = this.internalTypes.get(key = this.typeKey(namespace, typeName))) != null) {
            return ioc;
        }
        return super.findType(namespace, typeName);
    }

    @Override
    public IOpenField findVar(String namespace, String name, boolean strictMatch) throws AmbiguousVarException {
        IOpenField res = null;
        if (namespace.equals("org.openl.this")) {
            res = this.module.getField(name, strictMatch);
        }
        return res != null ? res : super.findVar(namespace, name, strictMatch);
    }

    public ModuleOpenClass getModule() {
        return this.module;
    }

    private synchronized Map<String, IOpenClass> initInternalTypes() {
        if (this.internalTypes == null) {
            this.internalTypes = new HashMap<String, IOpenClass>();
        }
        return this.internalTypes;
    }

    final String typeKey(String namespace, String typeName) {
        return namespace + "::" + typeName;
    }
}

