/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.openl.binding.MethodUtil;
import org.openl.conf.AConfigurationElement;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.conf.OpenConfigurationException;
import org.openl.util.Log;
import org.openl.util.RuntimeExceptionWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFactory
extends AConfigurationElement {
    static final Class<?>[] NO_PARAMS = new Class[0];
    protected String className;
    protected String extendsClassName;
    protected boolean singleton;
    Object cachedObject = null;

    public static Class<?> forName(String name, ClassLoader cl) {
        try {
            return cl.loadClass(name);
        }
        catch (ClassNotFoundException ex) {
            throw RuntimeExceptionWrapper.wrap((Throwable)ex);
        }
        catch (NoClassDefFoundError ex) {
            Log.debug((Object)("Potential problem loading class: " + name), (Throwable)ex);
            throw RuntimeExceptionWrapper.wrap((Throwable)ex);
        }
        catch (Throwable t) {
            Log.error((Object)("Error loading class: " + name), (Throwable)t);
            throw RuntimeExceptionWrapper.wrap((Throwable)t);
        }
    }

    public static Object newInstance(Class<?> cc, String uri) throws OpenConfigurationException {
        try {
            return cc.newInstance();
        }
        catch (Throwable t) {
            throw new OpenConfigurationException("Error creating new " + cc.getName(), uri, t);
        }
    }

    public static Object newInstance(String classname, IConfigurableResourceContext cxt, String uri) throws OpenConfigurationException {
        try {
            return cxt.getClassLoader().loadClass(classname).newInstance();
        }
        catch (Throwable t) {
            throw new OpenConfigurationException("Error creating new " + classname, uri, t);
        }
    }

    public static Object newInstanceForName(String className, ClassLoader cl) {
        try {
            return ClassFactory.forName(className, cl).newInstance();
        }
        catch (Exception ex) {
            throw RuntimeExceptionWrapper.wrap((Throwable)ex);
        }
    }

    public static Class<?> validateClassExistsAndPublic(String className, ClassLoader cl, String uri) throws OpenConfigurationException {
        Class<?> c;
        try {
            c = cl.loadClass(className);
        }
        catch (Throwable t) {
            throw new OpenConfigurationException("Can not load class: " + className, uri, t);
        }
        if (!Modifier.isPublic(c.getModifiers())) {
            throw new OpenConfigurationException(c.getName() + " must be public ", uri, null);
        }
        return c;
    }

    public static Constructor<?> validateHasConstructor(Class<?> clazz, Class<?>[] params, String uri) throws OpenConfigurationException {
        Constructor<?> c;
        try {
            c = clazz.getConstructor(params);
        }
        catch (Throwable t) {
            String methodString = MethodUtil.printMethod("", params);
            throw new OpenConfigurationException("Class " + clazz.getName() + " does not have a constructor " + methodString, uri, t);
        }
        if (!Modifier.isPublic(c.getModifiers())) {
            throw new OpenConfigurationException("Constructor " + clazz.getName() + MethodUtil.printMethod("", params) + " must be public ", uri, null);
        }
        return c;
    }

    public static Method validateHasMethod(Class<?> clazz, String methodName, Class<?>[] params, String uri) throws OpenConfigurationException {
        Method m;
        try {
            m = clazz.getMethod(methodName, params);
        }
        catch (Throwable t) {
            String methodString = MethodUtil.printMethod(methodName, params);
            throw new OpenConfigurationException("Class " + clazz.getName() + " does not have a method " + methodString, uri, t);
        }
        if (!Modifier.isPublic(m.getModifiers())) {
            throw new OpenConfigurationException(methodName + " must be public ", uri, null);
        }
        return m;
    }

    public static void validateHaveNewInstance(Class<?> clazz, String uri) throws OpenConfigurationException {
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new OpenConfigurationException(clazz.getName() + " must not be abstract ", uri, null);
        }
        try {
            Constructor<?> constr = clazz.getConstructor(NO_PARAMS);
            if (!Modifier.isPublic(constr.getModifiers())) {
                throw new OpenConfigurationException("Default constructor of " + clazz.getName() + " must be public", uri, null);
            }
        }
        catch (OpenConfigurationException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new OpenConfigurationException(clazz.getName() + " must have a default constructor", uri, null);
        }
    }

    public static void validateSuper(Class<?> clazz, Class<?> superClazz, String uri) throws OpenConfigurationException {
        if (!superClazz.isAssignableFrom(clazz)) {
            String verb = superClazz.isInterface() ? "implement" : "extend";
            throw new OpenConfigurationException(clazz.getName() + " does not " + verb + " " + superClazz.getName(), uri, null);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public String getExtendsClassName() {
        return this.extendsClassName;
    }

    public synchronized Object getResource(IConfigurableResourceContext cxt) throws OpenConfigurationException {
        if (this.isSingleton() && this.cachedObject != null) {
            return this.cachedObject;
        }
        this.cachedObject = this.getResourceInternal(cxt);
        return this.cachedObject;
    }

    protected Object getResourceInternal(IConfigurableResourceContext cxt) throws OpenConfigurationException {
        try {
            return cxt.getClassLoader().loadClass(this.className).newInstance();
        }
        catch (Throwable t) {
            throw new OpenConfigurationException("Error creating " + this.className, this.getUri(), t);
        }
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public void setExtendsClassName(String string) {
        this.extendsClassName = string;
    }

    public void setSingleton(boolean b) {
        this.singleton = b;
    }

    @Override
    public void validate(IConfigurableResourceContext cxt) throws OpenConfigurationException {
        Class<?> c = ClassFactory.validateClassExistsAndPublic(this.className, cxt.getClassLoader(), this.getUri());
        if (this.getExtendsClassName() != null) {
            Class<?> c2 = ClassFactory.validateClassExistsAndPublic(this.getExtendsClassName(), cxt.getClassLoader(), this.uri);
            ClassFactory.validateSuper(c, c2, this.getUri());
        }
        ClassFactory.validateHaveNewInstance(c, this.getUri());
    }
}

