/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.openl.OpenL;
import org.openl.conf.IUserContext;
import org.openl.util.ASelector;
import org.openl.util.IOpenIterator;
import org.openl.util.ISelector;
import org.openl.util.Log;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.util.tree.FileTreeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderFactory {
    static HashMap<Key, ClassLoader> userClassLoaders = new HashMap();

    public static ClassLoader createClassLoader(String classpath, ClassLoader parent, IUserContext ucxt) throws Exception {
        return ClassLoaderFactory.createClassLoader(ClassLoaderFactory.splitClassPath(classpath), parent, ucxt);
    }

    public static ClassLoader createClassLoader(String[] classpath, ClassLoader parent, IUserContext ucxt) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (int i = 0; i < classpath.length; ++i) {
            if (classpath[i].endsWith("*")) {
                ClassLoaderFactory.makeWildcardPath(ClassLoaderFactory.makeFile(ucxt.getUserHome(), classpath[i].substring(0, classpath[i].length() - 1)), urls);
                continue;
            }
            File f = ClassLoaderFactory.makeFile(ucxt.getUserHome(), classpath[i]);
            if (!f.exists()) {
                throw new IOException("File " + f.getPath() + " does not exist");
            }
            urls.add(ClassLoaderFactory.makeFile(ucxt.getUserHome(), classpath[i]).toURI().toURL());
        }
        URL[] uurl = urls.toArray(new URL[urls.size()]);
        return new URLClassLoader(uurl, parent);
    }

    public static synchronized ClassLoader createUserClassloader(String name, String classpath, ClassLoader parent, IUserContext ucxt) throws Exception {
        Log.debug((Object)("name=" + name + " cp=" + classpath + " " + ucxt + " cl=" + parent));
        Key key = new Key(name, classpath, parent, ucxt);
        ClassLoader loader = userClassLoaders.get(key);
        Log.debug((Object)(loader == null ? "New" : "Old"));
        if (loader == null) {
            loader = ClassLoaderFactory.createClassLoader(classpath, parent, ucxt);
            userClassLoaders.put(key, loader);
        }
        return loader;
    }

    public static ClassLoader getOpenlCoreLoader(ClassLoader ucl) {
        try {
            Class<?> c = ucl.loadClass(OpenL.class.getName());
            if (c != null) {
                return ucl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return OpenL.class.getClassLoader();
    }

    static File makeFile(String root, String name) throws Exception {
        File f = new File(name);
        if (f.isAbsolute() || name.startsWith("/")) {
            return f.getCanonicalFile();
        }
        return new File(root, name).getCanonicalFile();
    }

    public static void makeWildcardPath(File root, List<URL> urls) {
        ASelector<File> sel = new ASelector<File>(){

            public boolean select(File f) {
                String apath = f.getAbsolutePath();
                boolean res = apath.endsWith(".jar") || apath.endsWith(".zip");
                return res;
            }
        };
        IOpenIterator iter = new FileTreeIterator(root, 0).select((ISelector)sel);
        while (iter.hasNext()) {
            File f = (File)iter.next();
            try {
                urls.add(f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw RuntimeExceptionWrapper.wrap((Throwable)e);
            }
        }
    }

    public static synchronized HashMap<Key, ClassLoader> reset() {
        HashMap<Key, ClassLoader> oldLoaders = userClassLoaders;
        userClassLoaders = new HashMap();
        return oldLoaders;
    }

    protected static String[] splitClassPath(String classpath) {
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        String[] res = new String[st.countTokens()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = st.nextToken();
        }
        return res;
    }

    static final class Key {
        String name;
        String classpath;
        ClassLoader parent;
        IUserContext cxt;

        Key(String name, String classpath, ClassLoader parent, IUserContext cxt) {
            this.name = name;
            this.classpath = classpath;
            this.parent = parent;
            this.cxt = cxt;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key k = (Key)obj;
            return new EqualsBuilder().append((Object)this.classpath, (Object)k.classpath).append((Object)this.cxt, (Object)k.cxt).append((Object)this.parent, (Object)k.parent).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.parent).append((Object)this.cxt).append((Object)this.classpath).toHashCode();
        }
    }
}

