/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import java.io.File;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.conf.IOpenLConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableResourceContext
implements IConfigurableResourceContext {
    private static final Log LOG = LogFactory.getLog(ConfigurableResourceContext.class);
    private static final String[] DEFAULT_FILESYSTEM_ROOTS = new String[]{".", ""};
    private IOpenLConfiguration config;
    private ClassLoader classLoader;
    private String[] fileSystemRoots;
    private Properties properties;

    public ConfigurableResourceContext(ClassLoader classLoader, IOpenLConfiguration config) {
        this(classLoader, DEFAULT_FILESYSTEM_ROOTS, config);
    }

    public ConfigurableResourceContext(ClassLoader classLoader, String[] fileSystemRoots) {
        this(classLoader, fileSystemRoots, null);
    }

    public ConfigurableResourceContext(ClassLoader classLoader, String[] fileSystemRoots, IOpenLConfiguration config) {
        this.classLoader = classLoader;
        this.fileSystemRoots = fileSystemRoots;
        this.config = config;
    }

    public ConfigurableResourceContext(IOpenLConfiguration config) {
        this(Thread.currentThread().getContextClassLoader(), DEFAULT_FILESYSTEM_ROOTS, config);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public Class<?> findClass(String className) {
        try {
            return this.getClassLoader().loadClass(className);
        }
        catch (Throwable t) {
            LOG.debug((Object)String.format("Cannot load class '%s'", className), t);
            return null;
        }
    }

    @Override
    public URL findClassPathResource(String url) {
        return this.getClassLoader().getResource(url);
    }

    @Override
    public File findFileSystemResource(String url) {
        File file = new File(url);
        if (file.isAbsolute() && file.exists()) {
            return file;
        }
        for (int i = 0; i < this.fileSystemRoots.length; ++i) {
            file = new File(this.fileSystemRoots[i], url);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    @Override
    public String findProperty(String propertyName) {
        String property = null;
        if (this.properties != null) {
            property = this.properties.getProperty(propertyName);
        }
        if (property != null) {
            return property;
        }
        return System.getProperty(propertyName);
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
        return this.classLoader;
    }

    @Override
    public IOpenLConfiguration getConfiguration() {
        return this.config;
    }
}

