/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.openl.conf.AConfigurationElement;
import org.openl.conf.ClassFactory;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.conf.ITypeFactoryConfigurationElement;
import org.openl.conf.OpenConfigurationException;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenSchema;
import org.openl.types.ITypeLibrary;
import org.openl.types.impl.DynamicTypeLibrary;

public class DynamicTypesConfiguration
extends AConfigurationElement
implements ITypeFactoryConfigurationElement {
    DynamicTypeLibrary library = null;
    List<DynamicTypeConfiguration> dynamicTypes = new ArrayList<DynamicTypeConfiguration>();

    public void addType(DynamicTypeConfiguration dtc) {
        this.dynamicTypes.add(dtc);
    }

    public synchronized ITypeLibrary getLibrary(IConfigurableResourceContext cxt) {
        if (this.library == null) {
            this.library = new DynamicTypeLibrary();
            for (DynamicTypeConfiguration dtc : this.dynamicTypes) {
                this.library.addType(dtc.getName(), dtc.makeOpenClass(cxt));
            }
        }
        return this.library;
    }

    public void validate(IConfigurableResourceContext cxt) throws OpenConfigurationException {
        for (DynamicTypeConfiguration dtc : this.dynamicTypes) {
            dtc.validate(cxt);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DynamicTypeConfiguration
    extends AConfigurationElement {
        String name;
        String className;

        public String getClassName() {
            return this.className;
        }

        public Class<?> getImplementingClass() {
            return IOpenClass.class;
        }

        public String getName() {
            return this.name;
        }

        IOpenClass makeOpenClass(IConfigurableResourceContext cxt) {
            try {
                Class<?> c = ClassFactory.validateClassExistsAndPublic(this.className, cxt.getClassLoader(), this.getUri());
                Class[] paramTypes = new Class[]{IOpenSchema.class, String.class};
                Constructor<?> cc = ClassFactory.validateHasConstructor(c, paramTypes, this.getUri());
                Object[] params = new Object[]{null, this.name};
                return (IOpenClass)cc.newInstance(params);
            }
            catch (Throwable e) {
                throw new OpenConfigurationException("Can not create OpenClass: " + this.name, this.getUri(), e);
            }
        }

        public void setClassName(String string) {
            this.className = string;
        }

        public void setName(String string) {
            this.name = string;
        }

        @Override
        public void validate(IConfigurableResourceContext cxt) throws OpenConfigurationException {
            if (this.name == null) {
                throw new OpenConfigurationException("Attribute name mudt not be empty", this.getUri(), null);
            }
            Class<?> c = ClassFactory.validateClassExistsAndPublic(this.className, cxt.getClassLoader(), this.getUri());
            Class[] params = new Class[]{IOpenSchema.class, String.class};
            ClassFactory.validateHasConstructor(c, params, this.getUri());
        }
    }
}

