/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openl.conf.AConfigurationElement;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.conf.ITypeFactoryConfigurationElement;
import org.openl.conf.OpenConfigurationException;
import org.openl.types.ITypeLibrary;
import org.openl.types.java.JavaImportTypeLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaImportTypeConfiguration
extends AConfigurationElement
implements ITypeFactoryConfigurationElement {
    private List<String> classes = new ArrayList<String>();
    private List<String> imports = new ArrayList<String>();
    private ITypeLibrary library = null;

    public void addConfiguredClassName(String className) {
        if (StringUtils.isNotEmpty((String)className)) {
            this.classes.add(className);
        }
    }

    public void addConfiguredImport(String anImport) {
        if (StringUtils.isNotEmpty((String)anImport)) {
            this.imports.add(anImport);
        }
    }

    @Override
    public synchronized ITypeLibrary getLibrary(IConfigurableResourceContext cxt) {
        if (this.library == null) {
            this.library = new JavaImportTypeLibrary(this.classes, this.imports, cxt.getClassLoader());
        }
        return this.library;
    }

    public void setAllImports(List<String> allImports) {
        if (allImports != null && !allImports.isEmpty()) {
            this.imports = new ArrayList<String>(allImports);
        }
    }

    public void setImport(String singleImport) {
        if (StringUtils.isNotEmpty((String)singleImport)) {
            this.imports.add(singleImport);
        }
    }

    @Override
    public void validate(IConfigurableResourceContext cxt) throws OpenConfigurationException {
    }
}

