/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import java.util.ArrayList;
import java.util.List;
import org.openl.OpenL;
import org.openl.conf.AOpenLBuilder;
import org.openl.conf.JavaImportTypeConfiguration;
import org.openl.conf.JavaLibraryConfiguration;
import org.openl.conf.LibraryFactoryConfiguration;
import org.openl.conf.NameSpacedLibraryConfiguration;
import org.openl.conf.NameSpacedTypeConfiguration;
import org.openl.conf.NoAntOpenLTask;
import org.openl.conf.OpenConfigurationException;
import org.openl.conf.TypeFactoryConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenLBuilderImpl
extends AOpenLBuilder {
    private String extendsCategory = "org.openl.j";
    private String category;
    private List<String> imports = new ArrayList<String>();
    private String libName;

    @Override
    public OpenL build(String category) throws OpenConfigurationException {
        OpenL.getInstance(this.extendsCategory, this.getUserEnvironmentContext());
        return super.build(category);
    }

    public String getCategory() {
        return this.category;
    }

    public String getExtendsCategory() {
        return this.extendsCategory;
    }

    public List<String> getImports() {
        return this.imports;
    }

    public String getLibName() {
        return this.libName;
    }

    @Override
    public NoAntOpenLTask getNoAntOpenLTask() {
        NoAntOpenLTask op = new NoAntOpenLTask();
        op.setExtendsCategory(this.extendsCategory);
        op.setCategory(this.category);
        if (this.libName != null) {
            LibraryFactoryConfiguration libraries = op.createLibraries();
            NameSpacedLibraryConfiguration library = new NameSpacedLibraryConfiguration();
            library.setNamespace("org.openl.this");
            JavaLibraryConfiguration javalib = new JavaLibraryConfiguration();
            javalib.setClassName(this.libName);
            library.addJavalib(javalib);
            libraries.addConfiguredLibrary(library);
        }
        if (!this.imports.isEmpty()) {
            TypeFactoryConfiguration types = op.createTypes();
            NameSpacedTypeConfiguration typelibrary = new NameSpacedTypeConfiguration();
            typelibrary.setNamespace("org.openl.this");
            JavaImportTypeConfiguration javaimport = new JavaImportTypeConfiguration();
            javaimport = new JavaImportTypeConfiguration();
            javaimport.setAllImports(this.imports);
            typelibrary.addConfiguration(javaimport);
            types.addConfiguredTypeLibrary(typelibrary);
        }
        return op;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setExtendsCategory(String extendsCategory) {
        this.extendsCategory = extendsCategory;
    }

    public void setImports(List<String> imports) {
        this.imports = imports;
    }

    public void setLibName(String libName) {
        this.libName = libName;
    }
}

