/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import java.io.File;
import java.net.URL;
import org.openl.conf.AConfigurationElement;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.conf.ITypeFactoryConfigurationElement;
import org.openl.conf.OpenConfigurationException;
import org.openl.types.IOpenFactory;
import org.openl.types.IOpenSchema;
import org.openl.types.ITypeLibrary;
import org.openl.util.RuntimeExceptionWrapper;

public class OpenSchemaConfiguration
extends AConfigurationElement
implements ITypeFactoryConfigurationElement {
    URL url;
    String factoryName;
    IOpenSchema schema;

    public ITypeLibrary getLibrary(IConfigurableResourceContext cxt) {
        if (this.schema == null) {
            try {
                IOpenFactory factory = cxt.getConfiguration().getOpenFactory(this.factoryName);
                this.schema = factory.getSchema(this.url.toExternalForm(), false);
            }
            catch (Exception ex) {
                throw RuntimeExceptionWrapper.wrap((Throwable)ex);
            }
        }
        return this.schema;
    }

    public void setFactory(String string) {
        this.factoryName = string;
    }

    public void setFile(File f) throws Exception {
        this.url = f.toURI().toURL();
    }

    public void setURL(String x) throws Exception {
        this.url = new URL(x);
    }

    public void validate(IConfigurableResourceContext cxt) throws OpenConfigurationException {
        if (this.factoryName == null) {
            throw new OpenConfigurationException("Attribute factory must be set for schema", this.getUri(), null);
        }
        if (this.url == null) {
            throw new OpenConfigurationException("Either attribute <file> or <url> must be set for schema", this.getUri(), null);
        }
        if (cxt.getConfiguration().getOpenFactory(this.factoryName) == null) {
            throw new OpenConfigurationException("Factory " + this.factoryName + " does not exist", this.getUri(), null);
        }
    }
}

