/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import org.openl.binding.ICastFactory;
import org.openl.binding.impl.StaticClassLibrary;
import org.openl.binding.impl.cast.CastFactory;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.conf.AConfigurationElement;
import org.openl.conf.ClassFactory;
import org.openl.conf.IConfigurableResourceContext;
import org.openl.conf.IConfigurationElement;
import org.openl.conf.OpenConfigurationException;
import org.openl.types.IOpenClass;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.CollectionsUtil;

public class TypeCastFactory
extends AConfigurationElement
implements IConfigurationElement {
    JavaCastComponent[] components = new JavaCastComponent[0];

    public void addJavaCast(JavaCastComponent cmp) {
        this.components = (JavaCastComponent[])CollectionsUtil.add((Object)this.components, (Object)cmp);
    }

    public IOpenCast getCast(IOpenClass from, IOpenClass to, IConfigurableResourceContext cxt) {
        for (int i = 0; i < this.components.length; ++i) {
            IOpenCast openCast = this.components[i].getCastFactory(cxt).getCast(from, to);
            if (openCast == null) continue;
            return openCast;
        }
        return null;
    }

    public void validate(IConfigurableResourceContext cxt) throws OpenConfigurationException {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].validate(cxt);
        }
    }

    public static class JavaCastComponent
    extends AConfigurationElement {
        String libraryClassName;
        String className;
        CastFactory factory = null;

        public synchronized ICastFactory getCastFactory(IConfigurableResourceContext cxt) {
            if (this.factory == null) {
                Class<?> libClass = ClassFactory.validateClassExistsAndPublic(this.libraryClassName, cxt.getClassLoader(), this.getUri());
                Class<?> implClass = ClassFactory.validateClassExistsAndPublic(this.className, cxt.getClassLoader(), this.getUri());
                this.factory = (CastFactory)ClassFactory.newInstance(implClass, this.getUri());
                this.factory.setMethodFactory(new StaticClassLibrary(JavaOpenClass.getOpenClass(libClass)));
            }
            return this.factory;
        }

        public void setClassName(String string) {
            this.className = string;
        }

        public void setLibraryClassName(String string) {
            this.libraryClassName = string;
        }

        public void validate(IConfigurableResourceContext cxt) throws OpenConfigurationException {
            ClassFactory.validateClassExistsAndPublic(this.libraryClassName, cxt.getClassLoader(), this.getUri());
            Class<?> implClass = ClassFactory.validateClassExistsAndPublic(this.className, cxt.getClassLoader(), this.getUri());
            ClassFactory.validateSuper(implClass, CastFactory.class, this.getUri());
            ClassFactory.validateHaveNewInstance(implClass, this.getUri());
        }
    }
}

