/*
 * Decompiled with CFR 0.152.
 */
package org.openl.conf;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.Stack;
import org.openl.conf.AUserContext;
import org.openl.conf.IExecutable;
import org.openl.conf.IUserContext;

public class UserContext
extends AUserContext {
    static ThreadLocal<Stack<IUserContext>> contextStack = new ThreadLocal();
    protected ClassLoader userClassLoader;
    protected String userHome;
    protected Properties userProperties;

    public static IUserContext currentContext() {
        Stack<IUserContext> stack = contextStack.get();
        if (stack == null || stack.size() == 0) {
            return null;
        }
        return stack.peek();
    }

    public static IUserContext makeOrLoadContext(ClassLoader cl, String home) {
        IUserContext cxt = UserContext.currentContext();
        if (cxt != null) {
            return cxt;
        }
        return new UserContext(cl, home);
    }

    public static void popCurrentContext() {
        contextStack.get().pop();
    }

    public static void pushCurrentContext(IUserContext cxt) {
        Stack<IUserContext> stack = contextStack.get();
        if (stack == null) {
            stack = new Stack();
            contextStack.set(stack);
        }
        stack.push(cxt);
    }

    public UserContext(ClassLoader userClassLoader, String userHome) {
        this(userClassLoader, userHome, null);
    }

    public UserContext(ClassLoader userClassLoader, String userHome, Properties userProperties) {
        this.userClassLoader = userClassLoader;
        this.userHome = userHome;
        this.userProperties = userProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(IExecutable exe) {
        try {
            UserContext.pushCurrentContext(this);
            Object object = exe.execute();
            return object;
        }
        finally {
            UserContext.popCurrentContext();
        }
    }

    public ClassLoader getUserClassLoader() {
        return this.userClassLoader;
    }

    public String getUserHome() {
        return this.userHome;
    }

    public Properties getUserProperties() {
        return this.userProperties;
    }

    private String printClassloader(ClassLoader ucl) {
        if (ucl == null) {
            return "null";
        }
        if (ucl instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)ucl).getURLs();
            StringBuilder sb = new StringBuilder();
            sb.append("ClassLoader URLs: ");
            for (URL url : urls) {
                sb.append(url.toExternalForm());
                sb.append(',');
            }
            return sb.toString();
        }
        return ucl.toString();
    }

    public String toString() {
        return "home=" + this.userHome + " cl=" + this.printClassloader(this.userClassLoader);
    }
}

