/*
 * Decompiled with CFR 0.152.
 */
package org.openl.engine;

import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.IBoundCode;
import org.openl.binding.IBoundMethodHeader;
import org.openl.binding.IBoundMethodNode;
import org.openl.binding.impl.Binder;
import org.openl.binding.impl.BindingContext;
import org.openl.binding.impl.BindingContextDelegator;
import org.openl.binding.impl.module.MethodBindingContext;
import org.openl.engine.OpenLBindManager;
import org.openl.engine.OpenLCompileManager;
import org.openl.engine.OpenLHolder;
import org.openl.engine.OpenLSourceManager;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.SourceType;
import org.openl.syntax.code.ProcessedCode;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.OpenMethodHeader;
import org.openl.types.java.JavaOpenClass;

public class OpenLCodeManager
extends OpenLHolder {
    private OpenLSourceManager sourceManager;
    private OpenLCompileManager compileManager;
    private OpenLBindManager bindManager;

    public OpenLCodeManager(OpenL openl) {
        super(openl);
        this.sourceManager = new OpenLSourceManager(openl);
        this.compileManager = new OpenLCompileManager(openl);
        this.bindManager = new OpenLBindManager(openl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOpenClass makeType(IOpenSourceCodeModule source, IBindingContextDelegator bindingContextDelegator) {
        try {
            if (bindingContextDelegator == null) {
                bindingContextDelegator = new BindingContextDelegator(this.getOpenL().getBinder().makeBindingContext());
            }
            bindingContextDelegator.pushErrors();
            ProcessedCode processedCode = this.sourceManager.processSource(source, SourceType.TYPE, bindingContextDelegator, false);
            IBoundCode boundCode = processedCode.getBoundCode();
            IOpenClass iOpenClass = boundCode.getTopNode().getType();
            return iOpenClass;
        }
        finally {
            bindingContextDelegator.popErrors();
        }
    }

    public CompositeMethod makeMethod(IOpenSourceCodeModule source, IOpenMethodHeader methodHeader, IBindingContext bindingContext) {
        CompositeMethod compositeMethod = new CompositeMethod(methodHeader, null);
        this.compileManager.compileMethod(source, compositeMethod, bindingContext);
        return compositeMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOpenMethodHeader makeMethodHeader(IOpenSourceCodeModule source, IBindingContextDelegator bindingContextDelegator) {
        if (bindingContextDelegator == null) {
            bindingContextDelegator = new BindingContextDelegator(new BindingContext((Binder)this.getOpenL().getBinder(), JavaOpenClass.VOID, this.getOpenL()));
        }
        try {
            bindingContextDelegator.pushErrors();
            ProcessedCode processedCode = this.sourceManager.processSource(source, SourceType.METHOD_HEADER, bindingContextDelegator, false);
            IBoundCode boundCode = processedCode.getBoundCode();
            IOpenMethodHeader iOpenMethodHeader = ((IBoundMethodHeader)boundCode.getTopNode()).getMethodHeader();
            return iOpenMethodHeader;
        }
        finally {
            bindingContextDelegator.popErrors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeMethod makeMethodWithUnknownType(IOpenSourceCodeModule source, String methodName, IMethodSignature signature, IOpenClass declaringClass, IBindingContext bindingContext) {
        OpenMethodHeader header = new OpenMethodHeader(methodName, NullOpenClass.the, signature, declaringClass);
        try {
            bindingContext.pushErrors();
            MethodBindingContext methodBindingContext = new MethodBindingContext(header, bindingContext);
            ProcessedCode processedCode = this.sourceManager.processSource(source, SourceType.METHOD_BODY, methodBindingContext, false);
            IBoundCode boundCode = processedCode.getBoundCode();
            IOpenClass retType = methodBindingContext.getReturnType();
            if (retType == NullOpenClass.the) {
                retType = boundCode.getTopNode().getType();
            }
            header.setTypeClass(retType);
            IBoundMethodNode boundMethodNode = this.bindManager.bindMethod(boundCode, header, bindingContext);
            CompositeMethod compositeMethod = new CompositeMethod(header, boundMethodNode);
            return compositeMethod;
        }
        finally {
            bindingContext.popErrors();
        }
    }
}

