/*
 * Decompiled with CFR 0.152.
 */
package org.openl.engine;

import java.util.List;
import org.openl.CompiledOpenClass;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundCode;
import org.openl.binding.IBoundMethodNode;
import org.openl.binding.impl.ExecutionModeBindingContextDelegator;
import org.openl.binding.impl.module.MethodBindingContext;
import org.openl.binding.impl.module.ModuleOpenClass;
import org.openl.engine.OpenLBindManager;
import org.openl.engine.OpenLHolder;
import org.openl.engine.OpenLSourceManager;
import org.openl.engine.OpenLValidationManager;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessages;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.SourceType;
import org.openl.syntax.code.ProcessedCode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.types.IOpenClass;
import org.openl.types.impl.CompositeMethod;
import org.openl.validation.ValidationResult;
import org.openl.validation.ValidationUtils;

public class OpenLCompileManager
extends OpenLHolder {
    private OpenLSourceManager sourceManager;
    private OpenLBindManager bindManager;
    private OpenLValidationManager validationManager;

    public OpenLCompileManager(OpenL openl) {
        super(openl);
        this.sourceManager = new OpenLSourceManager(openl);
        this.bindManager = new OpenLBindManager(openl);
        this.validationManager = new OpenLValidationManager(openl);
    }

    public IOpenClass compileModule(IOpenSourceCodeModule source, boolean executionMode) {
        ProcessedCode processedCode = executionMode ? this.sourceManager.processSource(source, SourceType.MODULE, new ExecutionModeBindingContextDelegator(null), false) : this.sourceManager.processSource(source, SourceType.MODULE);
        IOpenClass openClass = processedCode.getBoundCode().getTopNode().getType();
        if (executionMode) {
            ((ModuleOpenClass)openClass).clearOddDataForExecutionMode();
        }
        return openClass;
    }

    public CompiledOpenClass compileModuleWithErrors(IOpenSourceCodeModule source, boolean executionMode) {
        ProcessedCode processedCode = executionMode ? this.sourceManager.processSource(source, SourceType.MODULE, new ExecutionModeBindingContextDelegator(null), true) : this.sourceManager.processSource(source, SourceType.MODULE, null, true);
        IOpenClass openClass = processedCode.getBoundCode().getTopNode().getType();
        SyntaxNodeException[] parsingErrors = processedCode.getParsingErrors();
        SyntaxNodeException[] bindingErrors = processedCode.getBindingErrors();
        if (!executionMode) {
            List<ValidationResult> validationResults = this.validationManager.validate(openClass);
            List<OpenLMessage> validationMessages = ValidationUtils.getValidationMessages(validationResults);
            OpenLMessages.getCurrentInstance().addMessages(validationMessages);
        }
        OpenLMessages messages = OpenLMessages.getCurrentInstance();
        if (executionMode) {
            ((ModuleOpenClass)openClass).clearOddDataForExecutionMode();
        }
        return new CompiledOpenClass(openClass, messages.getMessages(), parsingErrors, bindingErrors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileMethod(IOpenSourceCodeModule source, CompositeMethod compositeMethod, IBindingContext bindingContext) {
        try {
            bindingContext.pushErrors();
            MethodBindingContext methodBindingContext = new MethodBindingContext(compositeMethod.getHeader(), bindingContext);
            ProcessedCode processedCode = this.sourceManager.processSource(source, SourceType.METHOD_BODY, methodBindingContext, false);
            IBoundCode boundCode = processedCode.getBoundCode();
            IBoundMethodNode boundMethodNode = this.bindManager.bindMethod(boundCode, compositeMethod.getHeader(), bindingContext);
            compositeMethod.setMethodBodyBoundNode(boundMethodNode);
        }
        finally {
            bindingContext.popErrors();
        }
    }
}

