/*
 * Decompiled with CFR 0.152.
 */
package org.openl.engine;

import org.openl.CompiledOpenClass;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.exception.MethodNotFoundException;
import org.openl.engine.OpenLCodeManager;
import org.openl.engine.OpenLCompileManager;
import org.openl.engine.OpenLRunManager;
import org.openl.exception.OpenLRuntimeException;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.SourceType;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.impl.CompositeMethod;

public class OpenLManager {
    public static IOpenClass makeType(OpenL openl, IOpenSourceCodeModule source, IBindingContextDelegator bindingContextDelegator) {
        OpenLCodeManager codeManager = new OpenLCodeManager(openl);
        return codeManager.makeType(source, bindingContextDelegator);
    }

    public static CompositeMethod makeMethod(OpenL openl, IOpenSourceCodeModule source, IOpenMethodHeader methodHeader, IBindingContext bindingContext) {
        OpenLCodeManager codeManager = new OpenLCodeManager(openl);
        return codeManager.makeMethod(source, methodHeader, bindingContext);
    }

    public static IOpenMethodHeader makeMethodHeader(OpenL openl, IOpenSourceCodeModule source, IBindingContextDelegator bindingContextDelegator) {
        OpenLCodeManager codeManager = new OpenLCodeManager(openl);
        return codeManager.makeMethodHeader(source, bindingContextDelegator);
    }

    public static CompositeMethod makeMethodWithUnknownType(OpenL openl, IOpenSourceCodeModule source, String methodName, IMethodSignature signature, IOpenClass declaringClass, IBindingContext bindingContext) {
        OpenLCodeManager codeManager = new OpenLCodeManager(openl);
        return codeManager.makeMethodWithUnknownType(source, methodName, signature, declaringClass, bindingContext);
    }

    public static void compileMethod(OpenL openl, IOpenSourceCodeModule source, CompositeMethod compositeMethod, IBindingContext bindingContext) {
        OpenLCompileManager compileManager = new OpenLCompileManager(openl);
        compileManager.compileMethod(source, compositeMethod, bindingContext);
    }

    public static IOpenClass compileModule(OpenL openl, IOpenSourceCodeModule source) {
        return OpenLManager.compileModule(openl, source, false);
    }

    public static CompiledOpenClass compileModuleWithErrors(OpenL openl, IOpenSourceCodeModule source) {
        return OpenLManager.compileModuleWithErrors(openl, source, false);
    }

    public static IOpenClass compileModule(OpenL openl, IOpenSourceCodeModule source, boolean executionMode) {
        OpenLCompileManager compileManager = new OpenLCompileManager(openl);
        return compileManager.compileModule(source, executionMode);
    }

    public static CompiledOpenClass compileModuleWithErrors(OpenL openl, IOpenSourceCodeModule source, boolean executionMode) {
        OpenLCompileManager compileManager = new OpenLCompileManager(openl);
        return compileManager.compileModuleWithErrors(source, executionMode);
    }

    public static Object runScript(OpenL openl, IOpenSourceCodeModule source) throws OpenLRuntimeException {
        OpenLRunManager runManager = new OpenLRunManager(openl);
        return runManager.runScript(source);
    }

    public static Object runMethod(OpenL openl, IOpenSourceCodeModule source, String methodName, IOpenClass[] paramTypes, Object[] params) throws OpenLRuntimeException, MethodNotFoundException, SyntaxNodeException {
        OpenLRunManager runManager = new OpenLRunManager(openl);
        return runManager.runMethod(source, methodName, paramTypes, params);
    }

    public static Object run(OpenL openl, IOpenSourceCodeModule source, SourceType sourceType) throws OpenLRuntimeException {
        OpenLRunManager runManager = new OpenLRunManager(openl);
        return runManager.run(source, sourceType);
    }
}

