/*
 * Decompiled with CFR 0.152.
 */
package org.openl.engine;

import org.openl.IOpenParser;
import org.openl.OpenL;
import org.openl.engine.OpenLHolder;
import org.openl.message.OpenLMessagesUtils;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.SourceType;
import org.openl.syntax.code.IParsedCode;
import org.openl.syntax.code.impl.ParsedCode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;

public class OpenLParseManager
extends OpenLHolder {
    public OpenLParseManager(OpenL openl) {
        super(openl);
    }

    public IParsedCode parseSource(IOpenSourceCodeModule source, SourceType sourceType) {
        IOpenParser parser = this.getParser();
        switch (sourceType) {
            case MODULE: {
                return parser.parseAsModule(source);
            }
            case METHOD_HEADER: {
                return parser.parseAsMethodHeader(source);
            }
            case METHOD_BODY: {
                return parser.parseAsMethodBody(source);
            }
            case TYPE: {
                return parser.parseAsType(source);
            }
            case INT_RANGE: {
                return parser.parseAsIntegerRange(source);
            }
            case DOUBLE_RANGE: {
                return parser.parseAsFloatRange(source);
            }
        }
        return this.getInvalidCode(source);
    }

    private IOpenParser getParser() {
        return this.getOpenL().getParser();
    }

    private IParsedCode getInvalidCode(IOpenSourceCodeModule source) {
        String message = String.format("Invalid source type: %s", source.getUri(0));
        SyntaxNodeException error = SyntaxNodeExceptionUtils.createError(message, source);
        OpenLMessagesUtils.addError(error);
        return new ParsedCode(null, source, new SyntaxNodeException[]{error});
    }
}

