/*
 * Decompiled with CFR 0.152.
 */
package org.openl.engine;

import org.openl.IOpenVM;
import org.openl.OpenL;
import org.openl.binding.IBoundCode;
import org.openl.binding.IBoundMethodNode;
import org.openl.binding.IBoundNode;
import org.openl.binding.exception.MethodNotFoundException;
import org.openl.binding.impl.LiteralBoundNode;
import org.openl.engine.OpenLCompileManager;
import org.openl.engine.OpenLHolder;
import org.openl.engine.OpenLSourceManager;
import org.openl.engine.OpenLUtils;
import org.openl.exception.OpenLRuntimeException;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.SourceType;
import org.openl.syntax.code.ProcessedCode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;

public class OpenLRunManager
extends OpenLHolder {
    private OpenLSourceManager sourceManager;
    private OpenLCompileManager compileManager;

    public OpenLRunManager(OpenL openl) {
        super(openl);
        this.sourceManager = new OpenLSourceManager(openl);
        this.compileManager = new OpenLCompileManager(openl);
    }

    public Object runMethod(IOpenSourceCodeModule source, String methodName, IOpenClass[] paramTypes, Object[] params) throws OpenLRuntimeException, MethodNotFoundException, SyntaxNodeException {
        IOpenClass openClass = this.compileManager.compileModule(source, false);
        IOpenVM vm = this.getOpenL().getVm();
        Object target = openClass.newInstance(vm.getRuntimeEnv());
        IOpenMethod method = OpenLUtils.getMethod(methodName, paramTypes, openClass);
        return method.invoke(target, params, vm.getRuntimeEnv());
    }

    public Object runScript(IOpenSourceCodeModule source) throws OpenLRuntimeException {
        return this.run(source, SourceType.METHOD_BODY);
    }

    public Object run(IOpenSourceCodeModule source, SourceType sourceType) throws OpenLRuntimeException {
        ProcessedCode processedCode = this.sourceManager.processSource(source, sourceType);
        IBoundCode boundCode = processedCode.getBoundCode();
        IBoundNode boundNode = boundCode.getTopNode();
        IOpenVM vm = this.getOpenL().getVm();
        if (boundNode instanceof IBoundMethodNode) {
            return vm.getRunner().run((IBoundMethodNode)boundNode, new Object[0]);
        }
        if (boundNode instanceof LiteralBoundNode) {
            return ((LiteralBoundNode)boundNode).getValue();
        }
        try {
            throw new Exception("Unrunnable Bound Node Type:" + boundNode.getClass().getName());
        }
        catch (Exception ex) {
            throw new OpenLRuntimeException(ex, boundNode);
        }
    }
}

