/*
 * Decompiled with CFR 0.152.
 */
package org.openl.engine;

import java.util.Map;
import org.openl.OpenL;
import org.openl.binding.IBindingContextDelegator;
import org.openl.binding.IBoundCode;
import org.openl.engine.OpenLBindManager;
import org.openl.engine.OpenLHolder;
import org.openl.engine.OpenLParseManager;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.SourceType;
import org.openl.syntax.code.IParsedCode;
import org.openl.syntax.code.ProcessedCode;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;

public class OpenLSourceManager
extends OpenLHolder {
    private OpenLParseManager parseManager;
    private OpenLBindManager bindManager;

    public OpenLSourceManager(OpenL openl) {
        super(openl);
        this.bindManager = new OpenLBindManager(openl);
        this.parseManager = new OpenLParseManager(openl);
    }

    public ProcessedCode processSource(IOpenSourceCodeModule source, SourceType sourceType) {
        return this.processSource(source, sourceType, null, false);
    }

    public ProcessedCode processSource(IOpenSourceCodeModule source, SourceType sourceType, IBindingContextDelegator bindingContextDelegator, boolean ignoreErrors) {
        IParsedCode parsedCode = this.parseManager.parseSource(source, sourceType);
        SyntaxNodeException[] parsingErrors = parsedCode.getErrors();
        if (!ignoreErrors && parsingErrors.length > 0) {
            throw new CompositeSyntaxNodeException("Parsing Error:", parsingErrors);
        }
        Map<String, Object> externalParams = source.getParams();
        if (externalParams != null) {
            parsedCode.setExternalParams(externalParams);
        }
        IBoundCode boundCode = this.bindManager.bindCode(bindingContextDelegator, parsedCode);
        SyntaxNodeException[] bindingErrors = boundCode.getErrors();
        if (!ignoreErrors && bindingErrors.length > 0) {
            throw new CompositeSyntaxNodeException("Binding Error:", bindingErrors);
        }
        ProcessedCode processedCode = new ProcessedCode();
        processedCode.setParsedCode(parsedCode);
        processedCode.setBoundCode(boundCode);
        return processedCode;
    }
}

