/*
 * Decompiled with CFR 0.152.
 */
package org.openl.engine;

import java.util.List;
import org.openl.base.INamedThing;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.binding.exception.MethodNotFoundException;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.util.AOpenIterator;
import org.openl.util.ASelector;
import org.openl.util.AStringConvertor;
import org.openl.util.ISelector;

public final class OpenLUtils {
    public static IOpenMethod getMethod(String methodName, IOpenClass[] paramTypes, IOpenClass openClass) {
        IOpenMethod method = null;
        if (paramTypes != null) {
            method = openClass.getMatchingMethod(methodName, paramTypes);
        } else {
            INamedThing.NameConverter sc = INamedThing.NAME_CONVERTOR;
            ASelector.StringValueSelector nameSel = new ASelector.StringValueSelector(methodName, (AStringConvertor)sc);
            List list = AOpenIterator.select(openClass.methods(), (ISelector)nameSel).asList();
            if (list.size() > 1) {
                throw new AmbiguousMethodException(methodName, IOpenClass.EMPTY, list);
            }
            if (list.size() == 1) {
                method = (IOpenMethod)list.get(0);
            }
        }
        if (method == null) {
            throw new MethodNotFoundException("Can not run method: ", methodName, paramTypes == null ? IOpenClass.EMPTY : paramTypes);
        }
        return method;
    }
}

