/*
 * Decompiled with CFR 0.152.
 */
package org.openl.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openl.ICompileContext;
import org.openl.OpenL;
import org.openl.engine.OpenLHolder;
import org.openl.types.IOpenClass;
import org.openl.validation.IOpenLValidator;
import org.openl.validation.ValidationResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenLValidationManager
extends OpenLHolder {
    public OpenLValidationManager(OpenL openl) {
        super(openl);
    }

    public List<ValidationResult> validate(IOpenClass openClass) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        ICompileContext context = this.getOpenL().getCompileContext();
        if (context != null && context.isValidationEnabled()) {
            Set<IOpenLValidator> validators = context.getValidators();
            for (IOpenLValidator validator : validators) {
                ValidationResult result = validator.validate(this.getOpenL(), openClass);
                results.add(result);
            }
        }
        return results;
    }
}

