/*
 * Decompiled with CFR 0.152.
 */
package org.openl.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.openl.exception.OpenLException;
import org.openl.exception.OpenLExceptionUtils;
import org.openl.main.SourceCodeURLTool;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.util.text.ILocation;

public class OpenLCompilationException
extends Exception
implements OpenLException {
    private static final long serialVersionUID = -8075090606797764194L;
    private Throwable insideCause;
    private ILocation location;
    private IOpenSourceCodeModule source;

    public OpenLCompilationException(String message, Throwable insideCause, ILocation location, IOpenSourceCodeModule source) {
        super(message);
        this.insideCause = insideCause;
        this.location = location;
        this.source = source;
    }

    public OpenLCompilationException(String message, Throwable cause, ILocation location) {
        this(message, cause, location, null);
    }

    public OpenLCompilationException(String message) {
        this(message, null, null, null);
    }

    public Throwable getOriginalCause() {
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)this.insideCause);
        if (rootCause != null) {
            return rootCause;
        }
        return this.insideCause;
    }

    public ILocation getLocation() {
        return this.location;
    }

    public IOpenSourceCodeModule getSourceModule() {
        return this.source;
    }

    public Throwable getCause() {
        return this.getOriginalCause();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        OpenLExceptionUtils.printError(this, printWriter);
        SourceCodeURLTool.printSourceLocation(this, printWriter);
        printWriter.close();
        return stringWriter.toString();
    }
}

