/*
 * Decompiled with CFR 0.152.
 */
package org.openl.impl;

import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import org.openl.CompiledOpenClass;
import org.openl.OpenL;
import org.openl.conf.IUserContext;
import org.openl.engine.OpenLManager;
import org.openl.message.OpenLMessages;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.ASourceCodeModule;
import org.openl.source.impl.FileSourceCodeModule;
import org.openl.source.impl.URLSourceCodeModule;
import org.openl.types.IOpenClass;
import org.openl.util.PropertiesLocator;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.vm.IRuntimeEnv;

public class OpenClassJavaWrapper {
    private CompiledOpenClass compiledClass;
    private IRuntimeEnv env;

    public OpenClassJavaWrapper(CompiledOpenClass compiledClass, IRuntimeEnv env) {
        this.compiledClass = compiledClass;
        this.env = env;
    }

    public CompiledOpenClass getCompiledClass() {
        return this.compiledClass;
    }

    public IRuntimeEnv getEnv() {
        return this.env;
    }

    public IOpenClass getOpenClass() {
        return this.compiledClass.getOpenClass();
    }

    public IOpenClass getOpenClassWithErrors() {
        return this.compiledClass.getOpenClassWithErrors();
    }

    public Object newInstance() {
        return this.getOpenClass().newInstance(this.env);
    }

    public static OpenClassJavaWrapper createWrapper(String openlName, IUserContext userContext, IOpenSourceCodeModule source) {
        return OpenClassJavaWrapper.createWrapper(openlName, userContext, source, false);
    }

    public static OpenClassJavaWrapper createWrapper(String openlName, IUserContext userContext, IOpenSourceCodeModule source, boolean executionMode) {
        OpenL openl = OpenL.getInstance(openlName, userContext);
        OpenLMessages.getCurrentInstance().clear();
        CompiledOpenClass openClass = OpenLManager.compileModuleWithErrors(openl, source, executionMode);
        return new OpenClassJavaWrapper(openClass, openl.getVm().getRuntimeEnv());
    }

    public static OpenClassJavaWrapper createWrapper(String openlName, IUserContext userContext, String filename) {
        return OpenClassJavaWrapper.createWrapper(openlName, userContext, filename, false);
    }

    public static IOpenSourceCodeModule getSourceCodeModule(String filename, IUserContext userContext) {
        String fileOrURL = PropertiesLocator.locateFileOrURL(filename, userContext.getUserClassLoader(), new String[]{userContext.getUserHome()});
        if (fileOrURL == null) {
            throw new RuntimeException("File " + filename + " is not found");
        }
        ASourceCodeModule source = null;
        try {
            source = fileOrURL.indexOf(58) < 2 ? new FileSourceCodeModule(fileOrURL, null) : new URLSourceCodeModule(new URL(fileOrURL));
        }
        catch (MalformedURLException e) {
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
        return source;
    }

    public static OpenClassJavaWrapper createWrapper(String openlName, IUserContext userContext, String filename, boolean executionMode) {
        String fileOrURL = PropertiesLocator.locateFileOrURL(filename, userContext.getUserClassLoader(), new String[]{userContext.getUserHome()});
        if (fileOrURL == null) {
            throw new RuntimeException("File " + filename + " is not found");
        }
        ASourceCodeModule source = null;
        try {
            source = fileOrURL.indexOf(58) < 2 ? new FileSourceCodeModule(fileOrURL, null) : new URLSourceCodeModule(new URL(fileOrURL));
        }
        catch (MalformedURLException e) {
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
        return OpenClassJavaWrapper.createWrapper(openlName, userContext, source, executionMode);
    }

    public static OpenClassJavaWrapper createWrapper(String openlName, IUserContext userContext, String filename, String srcClass) {
        return OpenClassJavaWrapper.createWrapper(openlName, userContext, filename, false);
    }

    public static OpenClassJavaWrapper createWrapper(String openlName, IUserContext userContext, String filename, String srcClass, boolean executionMode) {
        if (srcClass == null) {
            return OpenClassJavaWrapper.createWrapper(openlName, userContext, filename, executionMode);
        }
        try {
            Class<?> sourceModuleClass = Class.forName(srcClass);
            Constructor<?> constructor = sourceModuleClass.getConstructor(String.class, IUserContext.class);
            IOpenSourceCodeModule module = (IOpenSourceCodeModule)constructor.newInstance(filename, userContext);
            return OpenClassJavaWrapper.createWrapper(openlName, userContext, module, executionMode);
        }
        catch (Exception e) {
            throw new RuntimeException("Can not instantiate source code module class(String source, IUserContext cxt):", e);
        }
    }
}

