/*
 * Decompiled with CFR 0.152.
 */
package org.openl.impl;

import org.openl.ICompileTime;
import org.openl.IOpenBinder;
import org.openl.IOpenL;
import org.openl.IOpenParser;
import org.openl.IOpenVM;
import org.openl.IRunTime;
import org.openl.binding.IBoundCode;
import org.openl.binding.IBoundMethodNode;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.code.IParsedCode;
import org.openl.syntax.exception.CompositeSyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeException;

public class OpenLImpl
implements IOpenL {
    ICompileTime compileTime;
    IRunTime runTime;

    public Object evaluate(IOpenSourceCodeModule code) {
        IParsedCode pc = this.getParser().parseAsMethodBody(code);
        SyntaxNodeException[] error = pc.getErrors();
        if (error.length > 0) {
            throw new CompositeSyntaxNodeException("Parsing Error:", error);
        }
        IBoundCode bc = this.getBinder().bind(pc);
        error = bc.getErrors();
        if (error.length > 0) {
            throw new CompositeSyntaxNodeException("Binding Error:", error);
        }
        return this.getVM().getRunner().run((IBoundMethodNode)bc.getTopNode(), new Object[0]);
    }

    public void extend(IOpenL openl) {
        if (openl == null) {
            return;
        }
        if (this.compileTime == null) {
            this.compileTime = openl.getCompileTime();
        } else {
            this.compileTime.extend(openl.getCompileTime());
        }
    }

    public IOpenBinder getBinder() {
        return this.getCompileTime().getBinder();
    }

    public ICompileTime getCompileTime() {
        return this.compileTime;
    }

    public IOpenParser getParser() {
        return this.getCompileTime().getParser();
    }

    public IRunTime getRunTime() {
        return this.runTime;
    }

    public IOpenVM getVM() {
        return this.getRunTime().getVM();
    }

    public void setCompileTime(ICompileTime time) {
        this.compileTime = time;
    }

    public void setRunTime(IRunTime time) {
        this.runTime = time;
    }
}

