/*
 * Decompiled with CFR 0.152.
 */
package org.openl.main;

import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import org.openl.OpenL;
import org.openl.conf.IUserContext;
import org.openl.engine.OpenLManager;
import org.openl.source.impl.ASourceCodeModule;
import org.openl.source.impl.FileSourceCodeModule;
import org.openl.source.impl.URLSourceCodeModule;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.java.OpenClassHelper;
import org.openl.util.Log;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class Engine {
    protected IOpenMethod method;
    protected Object instance;
    protected IRuntimeEnv env;
    protected IOpenClass openClass;

    protected static boolean looksLikeFile(String fileNameOrURL) {
        int idx = fileNameOrURL.indexOf(58);
        return idx < 2;
    }

    public Engine(String openlName, String fileName, String methodName) {
        this(openlName, fileName, methodName, (Class[])null);
    }

    public Engine(String openlName, String fileName, String methodName, Class<?>[] paramTypes) {
        OpenL openl = OpenL.getInstance(openlName);
        this.init(openl, fileName, methodName, paramTypes);
    }

    public Engine(String openlName, String fileName, String methodName, Class<?>[] paramTypes, IUserContext ucxt) {
        OpenL openl = OpenL.getInstance(openlName, ucxt);
        this.init(openl, fileName, methodName, null);
    }

    public Engine(String openlName, String fileName, String methodName, IUserContext ucxt) {
        this(openlName, fileName, methodName, null, ucxt);
    }

    private void init(OpenL openl, String fileName, String methodName, Class<?>[] paramTypes) {
        try {
            ASourceCodeModule src = Engine.looksLikeFile(fileName) ? new FileSourceCodeModule(fileName, null) : new URLSourceCodeModule(new URL(fileName));
            this.openClass = OpenLManager.compileModule(openl, src);
            if (methodName != null) {
                IOpenClass[] paramsArray = this.getOpenLParamsArray(paramTypes);
                this.method = this.openClass.getMatchingMethod(methodName, paramsArray);
                if (this.method == null) {
                    throw new RuntimeException("Method " + methodName + " not found");
                }
            }
            this.env = openl.getVm().getRuntimeEnv();
            this.instance = this.openClass.newInstance(this.env);
        }
        catch (Exception ex) {
            Log.error((Object)ex);
            throw RuntimeExceptionWrapper.wrap((Throwable)ex);
        }
    }

    private IOpenClass[] getOpenLParamsArray(Class<?>[] paramTypes) {
        ArrayList<IOpenClass> paramOpenClasses = new ArrayList<IOpenClass>();
        if (paramTypes != null) {
            for (Class<?> paramType : paramTypes) {
                paramOpenClasses.add(OpenClassHelper.getOpenClass(this.openClass, paramType));
            }
        }
        IOpenClass[] resultArray = (IOpenClass[])Array.newInstance(IOpenClass.class, paramOpenClasses.size());
        IOpenClass[] paramsArray = null;
        try {
            paramsArray = paramOpenClasses.toArray(resultArray);
        }
        catch (ArrayStoreException e) {
            // empty catch block
        }
        return paramsArray;
    }

    public Object run(Object[] objects) {
        return this.method.invoke(this.instance, objects, this.env);
    }

    public void setMethod(String methodName) {
        this.method = this.openClass.getMatchingMethod(methodName, null);
        if (this.method == null) {
            throw new RuntimeException("Method " + methodName + " not found");
        }
    }
}

