/*
 * Decompiled with CFR 0.152.
 */
package org.openl.main;

import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.openl.exception.OpenLException;
import org.openl.main.SourceCodeURLConstants;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.util.StringTool;
import org.openl.util.text.ILocation;
import org.openl.util.text.TextInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceCodeURLTool
implements SourceCodeURLConstants {
    public static String makeSourceLocationURL(ILocation location, IOpenSourceCodeModule module, String openl) {
        if (module != null && StringUtils.isEmpty((String)module.getUri(0))) {
            return "";
        }
        int position = 0;
        int start = -1;
        int end = -1;
        String lineInfo = null;
        if (location != null && location.isTextLocation()) {
            String src = module.getCode();
            TextInfo info = new TextInfo(src);
            start = location.getStart().getAbsolutePosition(info) + module.getStartPosition();
            end = location.getEnd().getAbsolutePosition(info) + module.getStartPosition();
            lineInfo = "start=" + start + "&" + "end" + "=" + end;
        }
        if (module == null) {
            return "NO_MODULE";
        }
        String moduleUri = module.getUri(position);
        String suffix = moduleUri.indexOf("?") < 0 ? "?" : "&";
        String url = moduleUri;
        if (lineInfo != null) {
            url = url + suffix + lineInfo;
            suffix = "&";
        } else if (location != null) {
            url = url + suffix + location;
            suffix = "&";
        }
        if (StringUtils.isNotEmpty((String)openl)) {
            url = url + suffix + "openl" + "=" + openl;
        }
        return url;
    }

    static void parseQuery(String query, Map<String, String> map) {
        if (query == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(query, "&");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            int idx = pair.indexOf(61);
            if (idx < 0) {
                map.put(pair, "");
                continue;
            }
            String key = pair.substring(0, idx);
            String value = pair.substring(idx + 1, pair.length());
            map.put(key, value);
        }
    }

    public static Map<String, String> parseUrl(String urls) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            URL url = new URL(urls);
            String file = url.getFile();
            String protocol = url.getProtocol();
            String host = url.getHost();
            String query = url.getQuery();
            int indexQuestionMark = file.indexOf(63);
            file = indexQuestionMark < 0 ? file : file.substring(0, indexQuestionMark);
            map.put("protocol", protocol);
            map.put("host", host);
            map.put("file", file);
            SourceCodeURLTool.parseQuery(query, map);
        }
        catch (MalformedURLException e) {
            map.put("error", e.getMessage());
        }
        return map;
    }

    public static void printCodeAndError(ILocation location, IOpenSourceCodeModule module, PrintWriter pw) {
        if (location == null) {
            return;
        }
        if (!location.isTextLocation()) {
            return;
        }
        String src = module.getCode();
        TextInfo info = new TextInfo(src);
        String[] lines = StringTool.splitLines((String)src);
        pw.println("Openl Code Fragment:");
        pw.println("=======================");
        int line1 = location.getStart().getLine(info);
        int column1 = location.getStart().getColumn(info, 1);
        int line2 = location.getEnd().getLine(info);
        int column2 = location.getEnd().getColumn(info, 1);
        int start = Math.max(line1 - 2, 0);
        int end = Math.min(start + 4, lines.length);
        for (int i = start; i < end; ++i) {
            String line = StringTool.untab((String)lines[i], (int)module.getTabSize());
            pw.println(line);
            if (i != line1) continue;
            StringBuffer buf = new StringBuffer(Math.max(column1, column2) + 5);
            StringTool.append((StringBuffer)buf, (char)' ', (int)column1);
            int col2 = line1 == line2 ? column2 + 1 : line.length();
            StringTool.append((StringBuffer)buf, (char)'^', (int)(col2 - column1));
            pw.println(buf.toString());
        }
        pw.println("=======================");
    }

    public static void printSourceLocation(ILocation location, IOpenSourceCodeModule module, PrintWriter pw) {
        String url = SourceCodeURLTool.makeSourceLocationURL(location, module, "");
        if (!StringUtils.isEmpty((String)url)) {
            pw.println("    at " + url);
        }
    }

    public static void printSourceLocation(OpenLException error, PrintWriter pw) {
        SourceCodeURLTool.printSourceLocation(error.getLocation(), error.getSourceModule(), pw);
    }

    public static void printSourceLocation(ISyntaxNode node, PrintWriter pw) {
        SourceCodeURLTool.printSourceLocation(node.getSourceLocation(), node.getModule(), pw);
    }
}

