/*
 * Decompiled with CFR 0.152.
 */
package org.openl.main;

import java.text.MessageFormat;

public class StackTrace {
    public static final String OPENL_FORMAT = "\tat file: {0}(line:{1})";
    public static final String OPENL_REGEXP = "*file: *(line:*)";
    public String fileName;
    public int line;

    public static StackTrace fromString(String s) {
        return new StackTrace(StackTrace.getFileName(s), StackTrace.getLineNumber(s));
    }

    static String getFileName(String linkText) {
        int index = linkText.lastIndexOf(40);
        return index >= 0 ? linkText.substring(0, index) : null;
    }

    static int getLineNumber(String s) {
        int index = s.lastIndexOf(58);
        if (index >= 0) {
            String numText = s.substring(index + 1, s.length() - 1);
            try {
                int line = Integer.parseInt(numText);
                return line > 0 ? line - 1 : line;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public StackTrace(String fileName, int line) {
        this.fileName = fileName;
        this.line = line;
    }

    public String toString() {
        Object[] args = new Object[]{this.fileName, new Integer(1 + this.line)};
        return MessageFormat.format(OPENL_FORMAT, args);
    }
}

