/*
 * Decompiled with CFR 0.152.
 */
package org.openl.meta;

import java.text.DecimalFormat;
import java.text.Format;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openl.base.INamedThing;
import org.openl.meta.DoubleValueFormula;
import org.openl.meta.DoubleValueFunction;
import org.openl.meta.IMetaHolder;
import org.openl.meta.IMetaInfo;
import org.openl.meta.ValueMetaInfo;
import org.openl.util.AOpenIterator;
import org.openl.util.tree.ITreeElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleValue
extends Number
implements IMetaHolder,
Comparable<Number>,
ITreeElement<DoubleValue>,
INamedThing {
    private static final long serialVersionUID = -4594250562069599646L;
    public static final int VALUE = 1;
    public static final int SHORT_NAME = 2;
    public static final int LONG_NAME = 4;
    public static final int URL = 8;
    public static final int EXPAND_FORMULA = 16;
    public static final int EXPAND_FUNCTION = 32;
    public static final int PRINT_VALUE_IN_EXPANDED = 64;
    public static final int EXPAND_ALL = 112;
    public static final int PRINT_ALL = 116;
    public static final DoubleValue ZERO = new DoubleValueZero();
    public static final DoubleValue ONE = new DoubleValueOne();
    private static Map<String, Format> formats = new HashMap<String, Format>();
    private String format = "#0.####";
    private IMetaInfo metaInfo;
    protected double value;

    public static DoubleValue add(DoubleValue dv1, DoubleValue dv2) {
        if (dv1 == null || dv1.getValue() == 0.0) {
            return dv2;
        }
        if (dv2 == null || dv2.getValue() == 0.0) {
            return dv1;
        }
        return new DoubleValueFormula(dv1, dv2, dv1.getValue() + dv2.getValue(), "+", false);
    }

    public static DoubleValue autocast(byte x, DoubleValue y) {
        return new DoubleValue(x);
    }

    public static DoubleValue autocast(short x, DoubleValue y) {
        return new DoubleValue(x);
    }

    public static DoubleValue autocast(char x, DoubleValue y) {
        return new DoubleValue(x);
    }

    public static DoubleValue autocast(int x, DoubleValue y) {
        return new DoubleValue(x);
    }

    public static DoubleValue autocast(long x, DoubleValue y) {
        return new DoubleValue(x);
    }

    public static DoubleValue autocast(float x, DoubleValue y) {
        return new DoubleValue(x);
    }

    public static DoubleValue autocast(double x, DoubleValue y) {
        return new DoubleValue(x);
    }

    public static DoubleValue autocast(Double x, DoubleValue y) {
        if (x == null) {
            return null;
        }
        return new DoubleValue(x);
    }

    public static byte cast(DoubleValue x, byte y) {
        return x.byteValue();
    }

    public static short cast(DoubleValue x, short y) {
        return x.shortValue();
    }

    public static char cast(DoubleValue x, char y) {
        return (char)x.doubleValue();
    }

    public static int cast(DoubleValue x, int y) {
        return x.intValue();
    }

    public static long cast(DoubleValue x, long y) {
        return x.longValue();
    }

    public static float cast(DoubleValue x, float y) {
        return x.floatValue();
    }

    public static double cast(DoubleValue x, double y) {
        return x.doubleValue();
    }

    public static Double cast(DoubleValue x, Double y) {
        if (x == null) {
            return null;
        }
        return x.doubleValue();
    }

    public static DoubleValue copy(DoubleValue value, String name) {
        if (value.getName() == null) {
            value.setName(name);
            return value;
        }
        if (!value.getName().equals(name)) {
            DoubleValueFunction dv = new DoubleValueFunction(value.doubleValue(), "COPY", new DoubleValue[]{value});
            dv.setName(name);
            return dv;
        }
        return value;
    }

    public static DoubleValue divide(DoubleValue dv1, DoubleValue dv2) {
        return new DoubleValueFormula(dv1, dv2, dv1.getValue() / dv2.getValue(), "/", true);
    }

    public static boolean eq(DoubleValue dv1, DoubleValue dv2) {
        return dv1.getValue() == dv2.getValue();
    }

    public static boolean ge(DoubleValue dv1, DoubleValue dv2) {
        return dv1.getValue() >= dv2.getValue();
    }

    public static synchronized Format getFormat(String fmt) {
        Format format = formats.get(fmt);
        if (format == null) {
            format = new DecimalFormat(fmt);
            formats.put(fmt, format);
        }
        return format;
    }

    public static boolean gt(DoubleValue dv1, DoubleValue dv2) {
        return dv1.getValue() > dv2.getValue();
    }

    public static boolean le(DoubleValue dv1, DoubleValue dv2) {
        return dv1.getValue() <= dv2.getValue();
    }

    public static boolean lt(DoubleValue dv1, DoubleValue dv2) {
        return dv1.getValue() < dv2.getValue();
    }

    public static DoubleValue max(DoubleValue dv1, DoubleValue dv2) {
        return new DoubleValueFunction(dv2.getValue() > dv1.getValue() ? dv2 : dv1, "max", new DoubleValue[]{dv1, dv2});
    }

    public static DoubleValue min(DoubleValue dv1, DoubleValue dv2) {
        return new DoubleValueFunction(dv2.getValue() < dv1.getValue() ? dv2 : dv1, "min", new DoubleValue[]{dv1, dv2});
    }

    public static DoubleValue multiply(DoubleValue dv1, DoubleValue dv2) {
        return new DoubleValueFormula(dv1, dv2, dv1.getValue() * dv2.getValue(), "*", true);
    }

    public static boolean ne(DoubleValue dv1, DoubleValue dv2) {
        return dv1.getValue() != dv2.getValue();
    }

    public static DoubleValue negative(DoubleValue dv) {
        DoubleValue neg = new DoubleValue(-dv.value);
        neg.metaInfo = dv.metaInfo;
        return neg;
    }

    public static DoubleValue pow(DoubleValue dv1, DoubleValue dv2) {
        return new DoubleValueFunction(Math.pow(dv1.value, dv2.value), "pow", new DoubleValue[]{dv1, dv2});
    }

    public static DoubleValue round(DoubleValue dv1) {
        return new DoubleValueFunction((double)Math.round(dv1.getValue()), "round", new DoubleValue[]{dv1});
    }

    public static DoubleValue round(DoubleValue d, DoubleValue p) {
        if (d == null) {
            return ZERO;
        }
        return new DoubleValueFunction((double)Math.round(d.doubleValue() / p.doubleValue()) * p.doubleValue(), "round", new DoubleValue[]{d, p});
    }

    public static DoubleValue subtract(DoubleValue dv1, DoubleValue dv2) {
        if (dv2 == null || dv2.getValue() == 0.0) {
            return dv1;
        }
        return new DoubleValueFormula(dv1, dv2, dv1.getValue() - dv2.getValue(), "-", false);
    }

    public DoubleValue() {
    }

    public DoubleValue(double value) {
        this.value = value;
    }

    public DoubleValue(double value, IMetaInfo metaInfo, String format) {
        this.metaInfo = metaInfo;
        this.value = value;
        this.format = format;
    }

    public DoubleValue(double value, String name) {
        this.value = value;
        ValueMetaInfo mi = new ValueMetaInfo();
        mi.setShortName(name);
        this.metaInfo = mi;
    }

    public DoubleValue(String valueString) {
        this.value = Double.parseDouble(valueString);
    }

    @Override
    public int compareTo(Number o) {
        return Double.compare(this.value, o.doubleValue());
    }

    public DoubleValue copy(String name) {
        return DoubleValue.copy(this, name);
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    public Iterator<DoubleValue> getChildren() {
        return AOpenIterator.empty();
    }

    public String getDisplayName(int mode) {
        switch (mode) {
            case 0: {
                return this.printValue();
            }
        }
        String name = this.metaInfo == null ? null : this.getMetaInfo().getDisplayName(mode);
        return name == null ? this.printValue() : name + "(" + this.printValue() + ")";
    }

    public String getFormat() {
        return this.format;
    }

    @Override
    public IMetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public String getName() {
        if (this.metaInfo == null) {
            return null;
        }
        return this.metaInfo.getDisplayName(2);
    }

    public DoubleValue getObject() {
        return this;
    }

    public String getType() {
        return "value";
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    public boolean isLeaf() {
        return true;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    protected String printContent(int mode, boolean fromMultiplicativeExpr, boolean inBrackets) {
        return this.printValue();
    }

    public String printExplanation(int mode, boolean fromMultiplicativeExpr, List<String> urls) {
        if (urls != null && this.metaInfo != null && this.metaInfo.getSourceUrl() != null) {
            urls.add("" + this.metaInfo.getDisplayName(2) + " -> " + this.metaInfo.getSourceUrl());
        }
        return this.printExplanationLocal(mode, fromMultiplicativeExpr);
    }

    protected String printExplanationLocal(int mode, boolean fromMultiplicativeExpr) {
        switch (mode & 0xFFFFFF8F) {
            case 1: {
                return this.printContent(mode, fromMultiplicativeExpr, false);
            }
            case 2: {
                return this.metaInfo == null ? this.printContent(mode, fromMultiplicativeExpr, false) : this.metaInfo.getDisplayName(2) + "(" + this.printContent(mode, false, true) + ")";
            }
            case 4: {
                return this.metaInfo == null ? this.printContent(mode, fromMultiplicativeExpr, false) : this.metaInfo.getDisplayName(2) + "(" + this.printContent(mode, false, true) + ")";
            }
        }
        throw new RuntimeException("Wrong print mode!!");
    }

    public String printValue() {
        return this.printValue(this.format);
    }

    public String printValue(String format) {
        return DoubleValue.getFormat(format).format(this.value);
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setFullName(String name) {
        if (this.metaInfo == null) {
            this.metaInfo = new ValueMetaInfo();
        }
        if (this.metaInfo instanceof ValueMetaInfo) {
            ((ValueMetaInfo)this.metaInfo).setFullName(name);
        }
    }

    @Override
    public void setMetaInfo(IMetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public void setName(String name) {
        if (this.metaInfo == null) {
            this.metaInfo = new ValueMetaInfo();
        }
        if (this.metaInfo instanceof ValueMetaInfo) {
            ((ValueMetaInfo)this.metaInfo).setShortName(name);
        }
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String toString() {
        return this.printValue();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DoubleValue) {
            DoubleValue secondObj = (DoubleValue)obj;
            return this.value == secondObj.doubleValue();
        }
        return false;
    }

    public int hashCode() {
        return Double.valueOf(this.value).hashCode();
    }

    public static class DoubleValueZero
    extends DoubleValue {
        private static final long serialVersionUID = 3329865368482848868L;

        public DoubleValue add(DoubleValue dv) {
            return dv;
        }

        public DoubleValue divide(DoubleValue dv) {
            return this;
        }

        public double getValue() {
            return 0.0;
        }

        public DoubleValue multiply(DoubleValue dv) {
            return this;
        }
    }

    public static class DoubleValueOne
    extends DoubleValue {
        private static final long serialVersionUID = 6347462002516785250L;

        public double getValue() {
            return 1.0;
        }

        public DoubleValue multiply(DoubleValue dv) {
            return dv;
        }
    }
}

