/*
 * Decompiled with CFR 0.152.
 */
package org.openl.meta;

import java.util.Iterator;
import org.openl.meta.DoubleValue;
import org.openl.util.OpenIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleValueFormula
extends DoubleValue {
    private static final long serialVersionUID = 3215205953478317387L;
    String operand;
    DoubleValue dv1;
    DoubleValue dv2;
    boolean isMultiplicative;

    public DoubleValueFormula(DoubleValue dv1, DoubleValue dv2, double value, String operand, boolean isMultiplicative) {
        this.dv1 = dv1;
        this.dv2 = dv2;
        this.value = value;
        this.operand = operand;
        this.isMultiplicative = isMultiplicative;
    }

    public DoubleValue[] getArguments() {
        return new DoubleValue[]{this.dv1, this.dv2};
    }

    @Override
    public Iterator<DoubleValue> getChildren() {
        return OpenIterator.fromArray((Object[])new DoubleValue[]{this.dv1, this.dv2});
    }

    @Override
    public String getDisplayName(int mode) {
        switch (mode) {
            case 0: {
                return super.getDisplayName(mode);
            }
        }
        return super.getDisplayName(mode) + " = " + this.dv1.getDisplayName(mode - 1) + this.operand + this.dv2.getDisplayName(mode - 1);
    }

    public DoubleValue getDv1() {
        return this.dv1;
    }

    public DoubleValue getDv2() {
        return this.dv2;
    }

    public String getOperand() {
        return this.operand;
    }

    @Override
    public String getType() {
        return "formula." + this.operand;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public boolean isMultiplicative() {
        return this.isMultiplicative;
    }

    @Override
    protected String printContent(int mode, boolean fromMultiplicativeExpr, boolean inBrackets) {
        if ((mode & 0x10) == 0) {
            return super.printContent(mode, fromMultiplicativeExpr, inBrackets);
        }
        StringBuffer res = new StringBuffer();
        if (!inBrackets && (!this.isMultiplicative && fromMultiplicativeExpr || (mode & 0x40) != 0 && this.isMultiplicative && !fromMultiplicativeExpr)) {
            res.append('(');
        }
        if ((mode & 0x40) != 0 && this.isMultiplicative && !fromMultiplicativeExpr) {
            res.append(this.printValue() + "=");
        }
        res.append(this.dv1.printExplanationLocal(mode, this.isMultiplicative));
        res.append(this.operand);
        res.append(this.dv2.printExplanationLocal(mode, this.isMultiplicative));
        if (!inBrackets && (!this.isMultiplicative && fromMultiplicativeExpr || (mode & 0x40) != 0 && this.isMultiplicative && !fromMultiplicativeExpr)) {
            res.append(')');
        }
        return res.toString();
    }

    public void setDv1(DoubleValue dv1) {
        this.dv1 = dv1;
    }

    public void setDv2(DoubleValue dv2) {
        this.dv2 = dv2;
    }

    public void setMultiplicative(boolean isMultiplicative) {
        this.isMultiplicative = isMultiplicative;
    }

    public void setOperand(String operand) {
        this.operand = operand;
    }
}

