/*
 * Decompiled with CFR 0.152.
 */
package org.openl.meta;

import java.util.Iterator;
import org.openl.meta.DoubleValue;
import org.openl.util.OpenIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleValueFunction
extends DoubleValue {
    private static final long serialVersionUID = -4252776600829254624L;
    String functionName;
    DoubleValue result;
    DoubleValue[] params = new DoubleValue[0];

    public DoubleValueFunction(double value, String functionName, DoubleValue[] params) {
        super(value);
        this.functionName = functionName;
        this.params = params;
        this.result = new DoubleValue(value);
    }

    public DoubleValueFunction(DoubleValue result, String functionName, DoubleValue[] params) {
        super(result.getValue());
        this.result = result;
        this.functionName = functionName;
        this.params = params;
    }

    public void addParam(DoubleValue param) {
        DoubleValue[] newParams = new DoubleValue[this.params.length + 1];
        for (int i = 0; i < this.params.length; ++i) {
            newParams[i] = this.params[i];
        }
        newParams[this.params.length] = param;
        this.params = newParams;
    }

    @Override
    public Iterator<DoubleValue> getChildren() {
        return OpenIterator.fromArray((Object[])this.params);
    }

    @Override
    public String getDisplayName(int mode) {
        switch (mode) {
            case 0: {
                return super.getDisplayName(mode);
            }
        }
        String f = this.functionName + '(';
        for (int i = 0; i < this.params.length; ++i) {
            if (i > 0) {
                f = f + ", ";
            }
            f = f + this.params[i].getDisplayName(mode - 1);
        }
        return super.getDisplayName(mode) + " = " + f + ')';
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public DoubleValue[] getParams() {
        return this.params;
    }

    public DoubleValue getResult() {
        return this.result;
    }

    @Override
    public String getType() {
        return "function";
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public String printContent(int mode, boolean fromMultiplicativeExpr, boolean inBrackets) {
        if ((mode & 0x20) == 0) {
            if (this.result == null) {
                return super.printContent(mode, false, inBrackets);
            }
            return this.result.printContent(mode, fromMultiplicativeExpr, inBrackets);
        }
        StringBuffer buf = new StringBuffer();
        if ((mode & 0x40) != 0) {
            if (!inBrackets) {
                buf.append('(');
            }
            buf.append(this.printValue() + "=");
        }
        buf.append(this.functionName);
        buf.append('(');
        for (int i = 0; i < this.params.length; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(this.params[i].printExplanationLocal(mode, false));
        }
        buf.append(')');
        if (!inBrackets && (mode & 0x40) != 0) {
            buf.append(')');
        }
        return buf.toString();
    }

    @Override
    public String printValue() {
        return this.result.printValue(this.getFormat());
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public void setParams(DoubleValue[] params) {
        this.params = params;
    }

    public void setResult(DoubleValue result) {
        this.result = result;
        this.value = result.doubleValue();
    }
}

