/*
 * Decompiled with CFR 0.152.
 */
package org.openl.meta;

import org.openl.meta.IMetaHolder;
import org.openl.meta.IMetaInfo;
import org.openl.meta.ValueMetaInfo;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringValue
implements IMetaHolder,
CharSequence,
Comparable<StringValue> {
    private IMetaInfo metaInfo;
    private String value;

    public StringValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Error initializing StringValue class. Parameter \"value\" can't be null.");
        }
        this.value = value;
        this.metaInfo = new ValueMetaInfo();
    }

    public StringValue(String value, String shortName, String fullName, IOpenSourceCodeModule source) {
        if (value == null) {
            throw new IllegalArgumentException("Error initializing StringValue class. Parameter \"value\" can't be null.");
        }
        this.value = value;
        this.metaInfo = new ValueMetaInfo(shortName, fullName, source);
    }

    public IOpenSourceCodeModule asSourceCodeModule() {
        return new StringSourceCodeModule(this.value, this.getMetaInfo().getSourceUrl());
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public int compareTo(StringValue v) {
        return this.value.compareTo(v.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof StringValue) {
            StringValue v = (StringValue)obj;
            return this.value.equals(v.value);
        }
        if (obj instanceof String) {
            String s = (String)obj;
            return this.value.equals(s);
        }
        return false;
    }

    @Override
    public IMetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.value.trim().length() == 0;
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public void setMetaInfo(IMetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.value;
    }
}

