/*
 * Decompiled with CFR 0.152.
 */
package org.openl.runtime;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.types.java.OpenClassHelper;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AEngineFactory {
    private static final String FIELD_PREFIX = "get";

    public abstract Object makeInstance();

    protected Object makeEngineInstance(Object openClassInstance, Map<Method, IOpenMember> methodMap, IRuntimeEnv runtimeEnv, ClassLoader classLoader) {
        Class<?>[] proxyInterfaces = this.getInstanceInterfaces();
        InvocationHandler handler = this.makeInvocationHandler(openClassInstance, methodMap, runtimeEnv);
        return Proxy.newProxyInstance(classLoader, proxyInterfaces, handler);
    }

    protected abstract Class<?>[] getInstanceInterfaces();

    protected abstract InvocationHandler makeInvocationHandler(Object var1, Map<Method, IOpenMember> var2, IRuntimeEnv var3);

    protected Map<Method, IOpenMember> makeMethodMap(Class<?> engineInterface, IOpenClass moduleOpenClass) {
        Method[] interfaceMethods;
        HashMap<Method, IOpenMember> methodMap = new HashMap<Method, IOpenMember>();
        for (Method interfaceMethod : interfaceMethods = engineInterface.getDeclaredMethods()) {
            IOpenClass[] params;
            String interfaceMethodName = interfaceMethod.getName();
            IOpenMethod rulesMethod = moduleOpenClass.getMatchingMethod(interfaceMethodName, params = OpenClassHelper.getOpenClasses(moduleOpenClass, interfaceMethod.getParameterTypes()));
            if (rulesMethod != null) {
                methodMap.put(interfaceMethod, rulesMethod);
                continue;
            }
            if (interfaceMethodName.startsWith(FIELD_PREFIX)) {
                String fieldName = StringUtils.uncapitalize((String)interfaceMethodName.substring(FIELD_PREFIX.length()));
                IOpenField rulesField = moduleOpenClass.getField(fieldName, true);
                if (rulesField == null) {
                    fieldName = StringUtils.capitalize((String)fieldName);
                    rulesField = moduleOpenClass.getField(fieldName, true);
                }
                if (rulesField != null) {
                    IOpenClass methodReturnType = OpenClassHelper.getOpenClass(moduleOpenClass, interfaceMethod.getReturnType());
                    if (methodReturnType.getInstanceClass() == rulesField.getType().getInstanceClass()) {
                        methodMap.put(interfaceMethod, rulesField);
                        continue;
                    }
                    String message = String.format("Return type of method \"%s\" should be %s", interfaceMethodName, rulesField.getType());
                    throw new RuntimeException(message);
                }
            }
            String message = String.format("There is no implementation in rules for interface method \"%s\"", interfaceMethod);
            throw new RuntimeException(message);
        }
        return methodMap;
    }
}

