/*
 * Decompiled with CFR 0.152.
 */
package org.openl.runtime;

import org.openl.OpenL;
import org.openl.conf.IUserContext;
import org.openl.conf.UserContext;
import org.openl.runtime.AEngineFactory;

public abstract class AOpenLEngineFactory
extends AEngineFactory {
    private OpenL openl;
    private IUserContext userContext;
    private String openlName;
    private String userHome = ".";

    public AOpenLEngineFactory(String openlName) {
        this.openlName = openlName;
    }

    public AOpenLEngineFactory(String openlName, String userHome) {
        this.openlName = openlName;
        this.userHome = userHome;
    }

    public AOpenLEngineFactory(String openlName, IUserContext userContext) {
        this.openlName = openlName;
        this.userContext = userContext;
    }

    public synchronized OpenL getOpenL() {
        if (this.openl == null) {
            this.openl = OpenL.getInstance(this.openlName, this.getUserContext());
        }
        return this.openl;
    }

    public synchronized IUserContext getUserContext() {
        if (this.userContext == null) {
            this.userContext = new UserContext(this.getDefaultUserClassLoader(), this.userHome);
        }
        return this.userContext;
    }

    protected ClassLoader getDefaultUserClassLoader() {
        ClassLoader userClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            userClassLoader.loadClass(this.getClass().getName());
        }
        catch (ClassNotFoundException cnfe) {
            userClassLoader = this.getClass().getClassLoader();
        }
        return userClassLoader;
    }
}

