/*
 * Decompiled with CFR 0.152.
 */
package org.openl.runtime;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import org.openl.CompiledOpenClass;
import org.openl.conf.IUserContext;
import org.openl.runtime.ASourceCodeEngineFactory;
import org.openl.runtime.EngineFactoryDefinition;
import org.openl.runtime.IEngineWrapper;
import org.openl.runtime.OpenLInvocationHandler;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.FileSourceCodeModule;
import org.openl.source.impl.URLSourceCodeModule;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMember;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineFactory<T>
extends ASourceCodeEngineFactory {
    protected Class<T> engineInterface;
    protected IOpenSourceCodeModule sourceCode;
    protected String sourceFile;
    protected CompiledOpenClass compiledOpenClass;
    protected Map<Method, IOpenMember> methodMap;

    public EngineFactory(String openlName, EngineFactoryDefinition factoryDef, Class<T> engineInterface) {
        super(openlName, factoryDef.sourceCode, factoryDef.ucxt);
        this.engineInterface = engineInterface;
    }

    public EngineFactory(String openlName, File file, Class<T> engineInterface) {
        super(openlName, file);
        this.engineInterface = engineInterface;
    }

    public EngineFactory(String openlName, String sourceFile, Class<T> engineInterface) {
        super(openlName, sourceFile);
        this.engineInterface = engineInterface;
    }

    public EngineFactory(String openlName, String sourceFile, Class<T> engineInterface, IUserContext userContext) {
        super(openlName, (IOpenSourceCodeModule)new FileSourceCodeModule(sourceFile, null), userContext);
        this.engineInterface = engineInterface;
    }

    public EngineFactory(String openlName, String userHome, String sourceFile, Class<T> engineInterface) {
        super(openlName, (IOpenSourceCodeModule)new FileSourceCodeModule(sourceFile, null), userHome);
        this.engineInterface = engineInterface;
    }

    public EngineFactory(String openlName, URL url, Class<T> engineInterface) {
        super(openlName, url);
        this.engineInterface = engineInterface;
    }

    public EngineFactory(String openlName, IOpenSourceCodeModule source, Class<T> engineInterface) {
        super(openlName, source);
        this.engineInterface = engineInterface;
    }

    public EngineFactory(String openlName, URL url, Class<T> engineInterface, IUserContext userContext) {
        super(openlName, (IOpenSourceCodeModule)new URLSourceCodeModule(url), userContext);
        this.engineInterface = engineInterface;
    }

    public synchronized IOpenClass getOpenClass() {
        IOpenClass openClass = this.getCompiledOpenClass().getOpenClass();
        this.methodMap = this.makeMethodMap(this.engineInterface, openClass);
        return openClass;
    }

    public synchronized CompiledOpenClass getCompiledOpenClass() {
        if (this.compiledOpenClass == null) {
            this.compiledOpenClass = this.initializeOpenClass();
        }
        return this.compiledOpenClass;
    }

    public void reset() {
        this.compiledOpenClass = null;
        this.methodMap = null;
    }

    @Override
    protected Class<?>[] getInstanceInterfaces() {
        return new Class[]{this.engineInterface, IEngineWrapper.class};
    }

    public T makeInstance() {
        IRuntimeEnv env = this.getOpenL().getVm().getRuntimeEnv();
        Object openClassInstance = this.getOpenClass().newInstance(env);
        return (T)this.makeEngineInstance(openClassInstance, this.methodMap, env, this.engineInterface.getClassLoader());
    }

    @Override
    protected InvocationHandler makeInvocationHandler(Object openClassInstance, Map<Method, IOpenMember> methodMap, IRuntimeEnv runtimeEnv) {
        return new OpenLInvocationHandler(openClassInstance, this, runtimeEnv, methodMap);
    }
}

