/*
 * Decompiled with CFR 0.152.
 */
package org.openl.runtime;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.openl.runtime.AEngineFactory;
import org.openl.runtime.IEngineWrapper;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenLInvocationHandler
implements InvocationHandler,
IEngineWrapper {
    private Object openlInstance;
    private AEngineFactory engineFactory;
    private IRuntimeEnv openlEnv;
    private Map<Method, IOpenMember> methodMap;

    public OpenLInvocationHandler(Object openlInstance, AEngineFactory engineFactory, IRuntimeEnv openlEnv, Map<Method, IOpenMember> methodMap) {
        this.openlInstance = openlInstance;
        this.engineFactory = engineFactory;
        this.openlEnv = openlEnv;
        this.methodMap = methodMap;
    }

    @Override
    public AEngineFactory getFactory() {
        return this.engineFactory;
    }

    @Override
    public Object getInstance() {
        return this.openlInstance;
    }

    @Override
    public IRuntimeEnv getRuntimeEnv() {
        return this.openlEnv;
    }

    protected Map<Method, IOpenMember> getMethodMap() {
        return this.methodMap;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == IEngineWrapper.class) {
            Method wrapperMethod = OpenLInvocationHandler.class.getDeclaredMethod(method.getName(), new Class[0]);
            return wrapperMethod.invoke((Object)this, args);
        }
        if (ArrayUtils.contains((Object[])this.engineFactory.getInstanceInterfaces(), method.getDeclaringClass())) {
            IOpenMember member = this.methodMap.get(method);
            if (member instanceof IOpenMethod) {
                IOpenMethod openMethod = (IOpenMethod)member;
                return openMethod.invoke(this.openlInstance, args, this.openlEnv);
            }
            IOpenField openField = (IOpenField)member;
            return openField.get(this.openlInstance, this.openlEnv);
        }
        Class[] cargs = new Class[]{};
        if (args != null && args.length == 1) {
            cargs = new Class[]{Object.class};
        }
        Method objectMethod = Object.class.getDeclaredMethod(method.getName(), cargs);
        return objectMethod.invoke((Object)this, args);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Proxy) {
            return Proxy.getInvocationHandler(obj) == this;
        }
        return super.equals(obj);
    }
}

