/*
 * Decompiled with CFR 0.152.
 */
package org.openl.runtime;

import java.util.HashMap;
import java.util.Map;
import org.openl.runtime.EngineFactory;
import org.openl.runtime.EngineFactoryDefinition;
import org.openl.runtime.IEngineRequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterizedEngineFactory<T, R> {
    protected IEngineRequestHandler<R> handler;
    protected Class<T> engineInterface;
    protected String openlName;
    Map<EngineFactoryDefinition, EngineFactory<T>> factoryMap = new HashMap<EngineFactoryDefinition, EngineFactory<T>>();

    public ParameterizedEngineFactory(String openlName, IEngineRequestHandler<R> handler, Class<T> engineInterface) {
        this.openlName = openlName;
        this.handler = handler;
        this.engineInterface = engineInterface;
    }

    public synchronized EngineFactory<T> getRuleEngineFactory(R request) {
        EngineFactoryDefinition factoryDef = this.handler.makeDefinition(request);
        EngineFactory<T> factory = this.factoryMap.get(factoryDef);
        if (factory != null) {
            return factory;
        }
        factory = this.makeFactory(factoryDef);
        this.factoryMap.put(factoryDef, factory);
        return factory;
    }

    protected EngineFactory<T> makeFactory(EngineFactoryDefinition factoryDef) {
        return new EngineFactory<T>(this.openlName, factoryDef, this.engineInterface);
    }
}

