/*
 * Decompiled with CFR 0.152.
 */
package org.openl.source.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.openl.source.impl.ASourceCodeModule;
import org.openl.util.RuntimeExceptionWrapper;

public class FileSourceCodeModule
extends ASourceCodeModule {
    private File file;
    private String externalUri;

    public FileSourceCodeModule(String fileName, String uri) {
        this(new File(fileName), uri);
    }

    public FileSourceCodeModule(File file, String uri) {
        this.file = file;
        this.externalUri = uri;
    }

    public FileSourceCodeModule(String fileName, String uri, int tabSize) {
        this(new File(fileName), uri);
        this.tabSize = tabSize;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getByteStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw RuntimeExceptionWrapper.wrap((String)"", (Throwable)e);
        }
    }

    public Reader getCharacterStream() {
        try {
            return new FileReader(this.file);
        }
        catch (FileNotFoundException e) {
            throw RuntimeExceptionWrapper.wrap((String)"", (Throwable)e);
        }
    }

    public FileSourceCodeModule getRelativeSourceCodeModule(String relativePath) {
        try {
            String dir = this.file.getParentFile().getCanonicalPath();
            File newFile = new File(dir + "/" + relativePath).getCanonicalFile();
            return new FileSourceCodeModule(newFile, null);
        }
        catch (IOException e) {
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
    }

    protected String makeUri() {
        try {
            return this.externalUri != null ? this.externalUri : this.file.getCanonicalFile().toURI().toURL().toExternalForm();
        }
        catch (Exception e) {
            throw RuntimeExceptionWrapper.wrap((String)"", (Throwable)e);
        }
    }
}

