/*
 * Decompiled with CFR 0.152.
 */
package org.openl.source.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.openl.source.IOpenSourceCodeModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringSourceCodeModule
implements IOpenSourceCodeModule {
    private String code;
    private String uri;
    private int tabSize = 2;
    private Map<String, Object> params;

    public StringSourceCodeModule(String code, String uri) {
        this.code = code;
        this.uri = uri;
    }

    public StringSourceCodeModule(String code, String uri, int tabSize) {
        this(code, uri);
        this.tabSize = tabSize;
    }

    @Override
    public InputStream getByteStream() {
        return new ByteArrayInputStream(this.code.getBytes());
    }

    @Override
    public Reader getCharacterStream() {
        return new StringReader(this.code);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public int getStartPosition() {
        return 0;
    }

    @Override
    public int getTabSize() {
        return this.tabSize;
    }

    @Override
    public String getUri(int textpos) {
        return this.uri;
    }

    @Override
    public Map<String, Object> getParams() {
        return this.params;
    }

    @Override
    public void setParams(Map<String, Object> params) {
        this.params = params;
    }
}

