/*
 * Decompiled with CFR 0.152.
 */
package org.openl.source.impl;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.openl.source.IOpenSourceCodeModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubTextSourceCodeModule
implements IOpenSourceCodeModule {
    private IOpenSourceCodeModule baseModule;
    private int startPosition;
    private int endPosition = 0;
    private Map<String, Object> params;

    public SubTextSourceCodeModule(IOpenSourceCodeModule baseModule, int startPosition) {
        this.baseModule = baseModule;
        this.startPosition = startPosition;
    }

    public SubTextSourceCodeModule(IOpenSourceCodeModule baseModule, int startPosition, int endPosition) {
        this.baseModule = baseModule;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    @Override
    public InputStream getByteStream() {
        return null;
    }

    @Override
    public Reader getCharacterStream() {
        return new StringReader(this.getCode());
    }

    @Override
    public String getCode() {
        String code = this.baseModule.getCode();
        int end = this.endPosition <= 0 ? code.length() + this.endPosition : this.endPosition;
        return code.substring(this.startPosition, end);
    }

    @Override
    public int getStartPosition() {
        return this.startPosition;
    }

    @Override
    public int getTabSize() {
        return this.baseModule.getTabSize();
    }

    @Override
    public String getUri(int textpos) {
        return this.baseModule.getUri(textpos + this.startPosition);
    }

    @Override
    public Map<String, Object> getParams() {
        return this.params;
    }

    @Override
    public void setParams(Map<String, Object> params) {
        this.params = params;
    }
}

